/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.layout.tablelayout;

import com.schneide.base.layout.tablelayout.OptionTranslation;
import com.schneide.base.layout.tablelayout.StringTableLayoutConstraint;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class ConstraintParser {
    private static final String FULL_STRING = "full";
    private static final String BOTTOM_STRING = "bottom";
    private static final String TOP_STRING = "top";
    private static final String RIGHT_STRING = "right";
    private static final String LEFT_STRING = "left";
    private static final String CENTER_STRING = "center";
    private static final Map<String, IConstraintApplication> APPLICATION_MAP = ConstraintParser.buildApplicationMap();
    private final StringTableLayoutConstraint layoutConstraint;
    private final OptionTranslation[] anchorTranslations = new OptionTranslation[]{new OptionTranslation("center", "center", "center"), new OptionTranslation("west", "left", "center"), new OptionTranslation("north", "center", "top"), new OptionTranslation("east", "right", "center"), new OptionTranslation("south", "center", "bottom"), new OptionTranslation("northwest", "left", "top"), new OptionTranslation("northeast", "right", "top"), new OptionTranslation("southwest", "left", "bottom"), new OptionTranslation("southeast", "right", "bottom")};
    private final OptionTranslation[] fillTranslations = new OptionTranslation[]{new OptionTranslation("horizontal", "full", null), new OptionTranslation("vertical", null, "full"), new OptionTranslation("both", "full", "full"), new OptionTranslation("none", null, null)};

    public ConstraintParser(StringTableLayoutConstraint constraint) {
        this.layoutConstraint = constraint;
    }

    private static void addToMap(Map<String, IConstraintApplication> map, IConstraintApplication application, String ... keys) {
        for (String key : keys) {
            map.put(key, application);
        }
    }

    private static Map<String, IConstraintApplication> buildApplicationMap() {
        HashMap<String, IConstraintApplication> result = new HashMap<String, IConstraintApplication>();
        ConstraintParser.addToMap(result, (constraint, component, value) -> constraint.setXpos(constraint.getSpecification().getColumnIndexWithSpacerColumns(Integer.parseInt(value))), "xpos", "gridx", "column", "x", "xposition");
        ConstraintParser.addToMap(result, (constraint, component, value) -> constraint.setYpos(constraint.getSpecification().getRowIndexWithSpacerRows(Integer.parseInt(value))), "ypos", "gridy", "row", "y", "yposition");
        ConstraintParser.addToMap(result, (constraint, component, value) -> constraint.setWidth(Integer.parseInt(value)), "width", "xspan", "columnspan", "w", "colspan");
        ConstraintParser.addToMap(result, (constraint, component, value) -> constraint.setHeight(Integer.parseInt(value)), "height", "yspan", "rowspan", "h");
        ConstraintParser.addToMap(result, (constraint, component, value) -> constraint.setHAlign(value), "horizontalalign", "horizontalalignment", "halign");
        ConstraintParser.addToMap(result, (constraint, component, value) -> constraint.setVAlign(value), "verticalalign", "verticalalignment", "valign");
        return result;
    }

    public void applyConstraint(Component component, String key, String value) {
        if (null == key) {
            throw new IllegalArgumentException("Could not resolve constraint with key null and value " + value);
        }
        String lowerCaseKey = key.toLowerCase();
        if (APPLICATION_MAP.containsKey(lowerCaseKey)) {
            APPLICATION_MAP.get(lowerCaseKey).applyConstraint(this.layoutConstraint, component, value);
            return;
        }
        this.applyMoreExoticConstraint(component, key, value);
    }

    private void applyMoreExoticConstraint(Component component, String key, String value) {
        if ("anchor".equalsIgnoreCase(key)) {
            this.applyAnchorConstraint(value);
        }
        if ("fill".equalsIgnoreCase(key)) {
            this.applyFillConstraint(value);
        }
        if ("insets".equalsIgnoreCase(key) || "margins".equalsIgnoreCase(key) || "border".equalsIgnoreCase(key)) {
            this.applyInsetsContraint(component, value);
        }
    }

    private void applyInsetsContraint(Component component, String value) {
        StringTokenizer valueTokenizer = new StringTokenizer(value, "[]: ");
        if (valueTokenizer.countTokens() != 4) {
            throw new IllegalArgumentException("Falsche Anzahl Parameter: [o, l, u, r]");
        }
        int top = this.parseInsetValue(valueTokenizer.nextToken());
        int left = this.parseInsetValue(valueTokenizer.nextToken());
        int bottom = this.parseInsetValue(valueTokenizer.nextToken());
        int right = this.parseInsetValue(valueTokenizer.nextToken());
        if (!(component instanceof JComponent)) {
            throw new IllegalArgumentException("Given component is not a JComponent: " + String.valueOf(component));
        }
        JComponent jComponent = (JComponent)component;
        jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(top, left, bottom, right), jComponent.getBorder()));
    }

    private int parseInsetValue(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    protected void applyAnchorConstraint(String anchor) {
        this.applyTranslatedConstraint(anchor, this.anchorTranslations);
    }

    private void applyTranslatedConstraint(String keyword, OptionTranslation[] translations) {
        for (OptionTranslation translation : translations) {
            if (!translation.fitsKey(keyword)) continue;
            this.applyTranslation(translation);
        }
    }

    private void applyTranslation(OptionTranslation element) {
        if (element.hasHAlign()) {
            this.layoutConstraint.setHAlign(element.getHAlign());
        }
        if (element.hasVAlign()) {
            this.layoutConstraint.setVAlign(element.getVAlign());
        }
    }

    protected void applyFillConstraint(String fill) {
        this.applyTranslatedConstraint(fill, this.fillTranslations);
    }

    private static interface IConstraintApplication {
        public void applyConstraint(StringTableLayoutConstraint var1, Component var2, String var3);
    }
}

