/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.layout;

import com.schneide.base.layout.StringGridBagConstraints;
import com.schneide.base.layout.StringGridBagHLine;
import com.schneide.base.layout.StringGridBagLine;
import com.schneide.base.layout.StringGridBagVLine;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.util.Enumeration;

public class StringGridBagLayout
extends GridBagLayout {
    private static final long serialVersionUID = 2196432278349434539L;
    private static boolean clientDebug;
    private static Color[] debugColors;
    private static int nextDebugColor;
    private Color debugColor;

    public StringGridBagLayout() {
        this.initDebugging();
        this.setDefaultConstraints(new StringGridBagConstraints());
    }

    public StringGridBagLayout(StringGridBagConstraints newDefaultConstraints) {
        this.initDebugging();
        this.setDefaultConstraints(newDefaultConstraints);
    }

    public StringGridBagLayout(String defaultConstraintsString) {
        this.initDebugging();
        StringGridBagConstraints newDefaultConstraints = new StringGridBagConstraints(defaultConstraintsString);
        this.setDefaultConstraints(newDefaultConstraints);
    }

    private void initDebugging() {
        if (debugColors == null) {
            debugColors = new Color[]{Color.black, Color.red, Color.blue, Color.white, Color.green};
        }
    }

    public static Color getNextDebugColor() {
        Color color = Color.black;
        if (debugColors != null) {
            color = debugColors[nextDebugColor];
            if (++nextDebugColor >= debugColors.length) {
                nextDebugColor = 0;
            }
        }
        return color;
    }

    public StringGridBagConstraints getDefaultConstraints() {
        StringGridBagConstraints constraints = null;
        constraints = this.defaultConstraints == null ? new StringGridBagConstraints() : (this.defaultConstraints instanceof StringGridBagConstraints ? (StringGridBagConstraints)this.defaultConstraints.clone() : new StringGridBagConstraints(this.defaultConstraints));
        return constraints;
    }

    public void setDefaultConstraints(StringGridBagConstraints newDefaultConstraints) {
        this.defaultConstraints = newDefaultConstraints == null ? new GridBagConstraints() : (StringGridBagConstraints)newDefaultConstraints.clone();
    }

    public void setDefaultConstraints(String newDefaultConstraints) {
        StringGridBagConstraints constraints = new StringGridBagConstraints(this.getDefaultConstraints(), newDefaultConstraints);
        this.setDefaultConstraints(constraints);
    }

    @Override
    public void addLayoutComponent(Component component, Object constraints) {
        if (constraints instanceof String) {
            this.addLayoutComponent((String)constraints, component);
        } else {
            super.addLayoutComponent(component, constraints);
        }
    }

    @Override
    public void addLayoutComponent(String params, Component component) {
        GridBagConstraints constraintsObject = this.getConstraints(component);
        StringGridBagConstraints constraints = null;
        constraints = constraintsObject == null ? this.getDefaultConstraints() : (constraintsObject instanceof StringGridBagConstraints ? (StringGridBagConstraints)constraintsObject : new StringGridBagConstraints(constraintsObject));
        constraints.setValues(params);
        super.addLayoutComponent(component, constraints);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension added;
        if (clientDebug) {
            this.ArrangeGrid(container);
        }
        Dimension min = super.minimumLayoutSize(container);
        if (clientDebug && (added = this.getDebugSizeDelta()) != null) {
            min.width += added.width;
            min.height += added.height;
        }
        return min;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension added;
        if (clientDebug) {
            this.ArrangeGrid(container);
        }
        Dimension pref = super.preferredLayoutSize(container);
        if (clientDebug && (added = this.getDebugSizeDelta()) != null) {
            pref.width += added.width;
            pref.height += added.height;
        }
        return pref;
    }

    private Dimension getDebugSizeDelta() {
        if (!clientDebug) {
            return null;
        }
        Dimension added = new Dimension(0, 0);
        int[][] gridArrays = this.getLayoutDimensions();
        int[] rows = gridArrays[1];
        int[] columns = gridArrays[0];
        added.width += 3 * (1 + columns.length);
        added.height += 3 * (1 + rows.length);
        return added;
    }

    @Override
    public void layoutContainer(Container container) {
        int i = 0;
        Component[] tmpComponents = container.getComponents();
        Component[] allComponents = new Component[tmpComponents.length];
        for (i = 0; i < tmpComponents.length; ++i) {
            allComponents[i] = tmpComponents[i];
        }
        for (i = 0; i < allComponents.length; ++i) {
            if (!(allComponents[i] instanceof StringGridBagLine)) continue;
            container.remove(allComponents[i]);
        }
        super.layoutContainer(container);
        if (clientDebug) {
            this.drawClientDebugLines(container);
        }
    }

    private void drawClientDebugLines(Container container) {
        int i;
        int[][] gridInfo = this.getLayoutDimensions();
        int[] currentColumnWidths = gridInfo[0];
        int[] currentRowHeights = gridInfo[1];
        if (this.debugColor == null) {
            this.debugColor = StringGridBagLayout.getNextDebugColor();
        }
        if (currentColumnWidths == null || currentRowHeights == null) {
            return;
        }
        Point origin = this.getLayoutOrigin();
        Dimension debugSizeDelta = this.getDebugSizeDelta();
        int layoutWidth = 0;
        for (i = 0; i < currentColumnWidths.length; ++i) {
            layoutWidth += currentColumnWidths[i];
        }
        layoutWidth += debugSizeDelta.width;
        int layoutHeight = 0;
        for (i = 0; i < currentRowHeights.length; ++i) {
            layoutHeight += currentRowHeights[i];
        }
        int layoutLeft = origin.x;
        int layoutTop = origin.y;
        this.drawVerticalLines(container, currentColumnWidths, layoutHeight += debugSizeDelta.height, layoutLeft, layoutTop);
        this.drawHorizontalLines(container, currentRowHeights, layoutWidth, layoutLeft, layoutTop);
    }

    private void drawHorizontalLines(Container container, int[] currentRowHeights, int layoutWidth, int layoutLeft, int layoutTop) {
        int y = layoutTop;
        int lineLeft = layoutLeft + 1;
        int lineLength = layoutWidth - 2;
        for (int i = 0; i < currentRowHeights.length; ++i) {
            StringGridBagHLine line;
            if (i == 0) {
                line = new StringGridBagHLine();
                line.setLineColor(this.debugColor);
                container.add(line);
                line.setBounds(lineLeft, y + 1, lineLength, 1);
                this.shiftComponentsBelowLine(y, 3);
                y += 3;
            }
            line = new StringGridBagHLine();
            line.setLineColor(this.debugColor);
            container.add(line);
            line.setBounds(lineLeft, (y += currentRowHeights[i]) + 1, lineLength, 1);
            this.shiftComponentsBelowLine(y, 3);
            y += 3;
        }
    }

    private void drawVerticalLines(Container container, int[] currentColumnWidths, int layoutHeight, int layoutLeft, int layoutTop) {
        int lineTop = layoutTop + 1;
        int lineLength = layoutHeight - 2;
        int x = layoutLeft;
        for (int i = 0; i < currentColumnWidths.length; ++i) {
            StringGridBagVLine line;
            if (i == 0) {
                line = new StringGridBagVLine();
                line.setLineColor(this.debugColor);
                container.add(line);
                line.setBounds(x + 1, lineTop, 1, lineLength);
                this.shiftComponentsRightOfLine(x, 3);
                x += 3;
            }
            line = new StringGridBagVLine();
            line.setLineColor(this.debugColor);
            container.add(line);
            line.setBounds((x += currentColumnWidths[i]) + 1, lineTop, 1, lineLength);
            this.shiftComponentsRightOfLine(x, 3);
            x += 3;
        }
    }

    private void shiftComponentsBelowLine(int lineY, int deltaY) {
        if (null == this.comptable) {
            return;
        }
        Enumeration iteration = this.comptable.keys();
        while (iteration.hasMoreElements()) {
            Component component = (Component)iteration.nextElement();
            Point oldLoc = component.getLocation();
            if (oldLoc.y < lineY) continue;
            component.setLocation(oldLoc.x, oldLoc.y + deltaY);
        }
    }

    private void shiftComponentsRightOfLine(int lineX, int deltaX) {
        if (null == this.comptable) {
            return;
        }
        Enumeration iteration = this.comptable.keys();
        while (iteration.hasMoreElements()) {
            Component component = (Component)iteration.nextElement();
            Point oldLoc = component.getLocation();
            if (oldLoc.x < lineX) continue;
            component.setLocation(oldLoc.x + deltaX, oldLoc.y);
        }
    }
}

