/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.writer;

import com.schneide.base.functional.No;
import com.schneide.base.io.virtual.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public final class WriteTo {
    private final PrintWriterProvider target;
    private Charset encoding;

    private WriteTo(PrintWriterProvider target) {
        this.target = target;
        this.encoding = Charset.defaultCharset();
    }

    public WriteTo with(Charset charset) {
        this.encoding = charset;
        return this;
    }

    public WriteTo as(String charsetName) {
        return this.with(Charset.forName(charsetName));
    }

    public static String string(Writing writing) throws IOException {
        try (StringWriter result = new StringWriter();){
            WriteTo write = new WriteTo(notUsed -> new PrintWriter(result));
            write.using(writing);
            String string = result.toString();
            return string;
        }
    }

    public static WriteTo file(File target) {
        return new WriteTo(useEncoding -> new PrintWriter(target, useEncoding.name()));
    }

    public static WriteTo virtualFile(VirtualFile target) {
        return new WriteTo(useEncoding -> new PrintWriter(new OutputStreamWriter(target.getOutputStream(), useEncoding)));
    }

    public static WriteTo writer(Writer writer) {
        return new WriteTo(notUsed -> new PrintWriter(writer));
    }

    public static WriteTo stream(OutputStream stream) {
        return new WriteTo(useEncoding -> new PrintWriter(new OutputStreamWriter(stream, useEncoding)));
    }

    public static WriteTo endOfVirtualFile(VirtualFile target) {
        return new WriteTo(useEncoding -> new PrintWriter(new OutputStreamWriter(target.getAppendingOutputStream(), useEncoding)));
    }

    public void using(Writing writing) throws IOException {
        try (PrintWriter writer = this.target.createPrintWriterWith(this.encoding);){
            writing.writeTo(writer);
        }
    }

    @FunctionalInterface
    protected static interface PrintWriterProvider {
        public PrintWriter createPrintWriterWith(Charset var1) throws IOException;
    }

    @FunctionalInterface
    public static interface Writing {
        public static final Writing empty = writer -> No.op();

        public void writeTo(PrintWriter var1) throws IOException;
    }
}

