/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.virtual.wrapper;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.VirtualFileCollection;
import com.schneide.base.io.virtual.filter.VirtualFileFilter;
import com.schneide.base.logging.LoggedObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class DeveloperOverdrive
extends LoggedObject
implements VirtualFile {
    private static final String overdriveEnding = ".developer";
    private final VirtualFile original;

    private DeveloperOverdrive(VirtualFile original) {
        this.original = original;
    }

    public static DeveloperOverdrive of(VirtualFile original) {
        return new DeveloperOverdrive(original);
    }

    private VirtualFile possiblyOverdriven() {
        VirtualFile overdrive = this.overdrive();
        if (overdrive.isFile()) {
            return overdrive;
        }
        return this.original;
    }

    private VirtualFile overdrive() {
        return this.original.getParent().getChild(this.original.getName() + overdriveEnding);
    }

    @Override
    public VirtualFile createFile(String name) throws IOException {
        return this.possiblyOverdriven().createFile(name);
    }

    @Override
    public VirtualFile createAsFile() throws IOException {
        return this.possiblyOverdriven().createAsFile();
    }

    @Override
    public boolean hasChild(String name) {
        return this.possiblyOverdriven().hasChild(name);
    }

    @Override
    public VirtualFile createAsDirectory() throws IOException {
        return this.possiblyOverdriven().createAsDirectory();
    }

    @Override
    public String getName() {
        return this.possiblyOverdriven().getName();
    }

    @Override
    public String getAbsoluteName() {
        return this.possiblyOverdriven().getAbsoluteName();
    }

    @Override
    public VirtualFile getParent() {
        return this.possiblyOverdriven().getParent();
    }

    @Override
    public VirtualFile getChild(String name) {
        return this.possiblyOverdriven().getChild(name);
    }

    @Override
    public Iterable<VirtualFile> listDirectory() {
        return this.possiblyOverdriven().listDirectory();
    }

    @Override
    public Iterable<VirtualFile> listDirectory(VirtualFileFilter filter) {
        return this.possiblyOverdriven().listDirectory(filter);
    }

    @Override
    public boolean isDirectory() {
        return this.possiblyOverdriven().isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.possiblyOverdriven().isFile();
    }

    @Override
    public boolean isLocal() {
        return this.possiblyOverdriven().isLocal();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.possiblyOverdriven().getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.possiblyOverdriven().getOutputStream();
    }

    @Override
    public OutputStream getAppendingOutputStream() throws IOException {
        return this.possiblyOverdriven().getAppendingOutputStream();
    }

    @Override
    public File getLocalFile() throws IOException {
        return this.possiblyOverdriven().getLocalFile();
    }

    @Override
    public void disposeLocalFile(File localFile) throws IOException {
        this.possiblyOverdriven().disposeLocalFile(localFile);
    }

    @Override
    public boolean exists() {
        return this.possiblyOverdriven().exists();
    }

    @Override
    public void copyContentTo(VirtualFile copy) throws IOException {
        this.possiblyOverdriven().copyContentTo(copy);
    }

    @Override
    public long saveContent(InputStream is) throws IOException {
        return this.possiblyOverdriven().saveContent(is);
    }

    @Override
    public String getCanonicalName() throws IOException {
        return this.possiblyOverdriven().getCanonicalName();
    }

    @Override
    public void setLastModified(long millis) {
        this.possiblyOverdriven().setLastModified(millis);
    }

    @Override
    public long getLastModified() {
        return this.possiblyOverdriven().getLastModified();
    }

    @Override
    public URL getUrl() {
        return this.possiblyOverdriven().getUrl();
    }

    @Override
    public long getSize() throws IOException {
        return this.possiblyOverdriven().getSize();
    }

    @Override
    public void dispose() throws IOException {
        this.possiblyOverdriven().dispose();
    }

    @Override
    public boolean isEmptyDirectory() {
        return this.possiblyOverdriven().isEmptyDirectory();
    }

    @Override
    public boolean canRead() {
        return this.possiblyOverdriven().canRead();
    }

    @Override
    public boolean canWrite() {
        return this.possiblyOverdriven().canWrite();
    }

    @Override
    public void renameTo(String newName) throws IOException {
        this.possiblyOverdriven().renameTo(newName);
    }

    @Override
    public void move(VirtualFile destination) throws IOException {
        this.possiblyOverdriven().move(destination);
    }

    @Override
    public void moveInto(VirtualFile targetDirectory) throws IOException {
        this.possiblyOverdriven().moveInto(targetDirectory);
    }

    @Override
    public VirtualFileCollection forEach(VirtualFileFilter filter) {
        return this.possiblyOverdriven().forEach(filter);
    }
}

