/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.virtual.visitor;

import com.schneide.base.io.file.FileOperation;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.filter.CombineWithOr;
import com.schneide.base.io.virtual.filter.VirtualFileFilter;
import com.schneide.base.io.virtual.operation.FilesystemOperation;
import com.schneide.base.io.virtual.visitor.FilteredVirtualFileVisitor;
import java.io.IOException;

public final class ForeachFile {
    private final VirtualFile parent;
    private final CombineWithOr blacklists;

    private ForeachFile(VirtualFile parent) {
        this.parent = parent;
        this.blacklists = CombineWithOr.startingAt(false);
    }

    public static ForeachFile in(VirtualFile directory) {
        return new ForeachFile(directory);
    }

    public void check(FileOperation operation) throws IOException {
        this.perform(operation);
    }

    public void check(FilesystemOperation operation) throws IOException {
        this.perform(operation);
    }

    public void apply(FileOperation operation) throws IOException {
        this.perform(operation);
    }

    public void apply(FilesystemOperation operation) throws IOException {
        this.perform(operation);
    }

    public void perform(final FileOperation operation) throws IOException {
        this.perform(new FilesystemOperation(){

            @Override
            public void onFile(VirtualFile file) throws IOException {
                operation.operateOn(file);
            }

            @Override
            public void onDirectory(VirtualFile directory) throws IOException {
            }
        });
    }

    public void perform(final FilesystemOperation operation) throws IOException {
        FilteredVirtualFileVisitor visitor = new FilteredVirtualFileVisitor(this, this.blacklists){

            @Override
            protected void performOnFile(VirtualFile file) throws IOException {
                operation.onFile(file);
            }

            @Override
            protected void performOnDirectory(VirtualFile directory) throws IOException {
                operation.onDirectory(directory);
            }
        };
        visitor.visitAllUnder(this.parent);
    }

    public ForeachFile except(VirtualFileFilter blacklist) {
        this.blacklists.or(blacklist);
        return this;
    }
}

