/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.virtual.local;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.io.file.FileLister;
import com.schneide.base.io.file.FileLocator;
import com.schneide.base.io.file.FileUtil;
import com.schneide.base.io.stream.pump.StreamPumper;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.VirtualFileBase;
import com.schneide.base.io.virtual.filter.VirtualFileFilter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;

public class LocalVirtualFile
extends VirtualFileBase {
    private final File file;

    public LocalVirtualFile(String filename) {
        this(new File(filename));
    }

    public LocalVirtualFile(File f) {
        if (f == null) {
            new Throwable().printStackTrace();
        }
        this.file = f;
    }

    public LocalVirtualFile(Path path) {
        this.file = path.toFile();
    }

    public static LocalVirtualFile forWorkingDirectory() {
        return new LocalVirtualFile(".");
    }

    public static LocalVirtualFile at(String filepath) {
        return new LocalVirtualFile(FileLocator.getFile(filepath));
    }

    public static LocalVirtualFile fileIn(File parentDirectory, String fileName) throws IOException {
        return LocalVirtualFile.fileAt(parentDirectory.getAbsolutePath() + "/" + fileName);
    }

    public static LocalVirtualFile fileAt(String filepath) throws IOException {
        return new LocalVirtualFile(filepath).createAsFile();
    }

    public static LocalVirtualFile directoryAt(String directoryPath) throws IOException {
        return new LocalVirtualFile(directoryPath).createAsDirectory();
    }

    @Override
    public LocalVirtualFile createAsFile() throws IOException {
        if (this.file.isFile()) {
            return this;
        }
        if (this.file.exists()) {
            throw new IOException("Already exists and is no file " + this.getName());
        }
        this.createNewFile();
        return this;
    }

    private void createNewFile() throws IOException {
        this.file.getParentFile().mkdirs();
        boolean success = this.file.createNewFile();
        if (!success) {
            throw new IOException("Could not create file " + this.getName());
        }
    }

    @Override
    public boolean canRead() {
        return this.getFile().canRead();
    }

    @Override
    public boolean canWrite() {
        return this.getFile().canWrite();
    }

    @Override
    public void renameTo(String newName) {
        FileUtil.ensureSuccessWithWarning("Error while renaming from " + this.getFile().getName() + " to " + newName, this.getFile().renameTo(new File(this.getFile().getParentFile(), newName)));
    }

    @Override
    public void move(VirtualFile newFile) throws IOException {
        if (newFile.exists()) {
            throw new IOException("Destination file already exists:" + newFile.getAbsoluteName());
        }
        FileUtil.ensureSuccess("Error while renaming from " + this.getFile().getAbsolutePath() + " to " + newFile.getAbsoluteName(), this.getFile().renameTo(newFile.getLocalFile()));
    }

    @Override
    public long getLastModified() {
        return this.getFile().lastModified();
    }

    @Override
    public void setLastModified(long millis) {
        FileUtil.ensureSuccessWithWarning("Error while setting timestamp to " + millis, this.getFile().setLastModified(millis));
    }

    @Override
    public boolean isEmptyDirectory() {
        return IterableUtil.isEmpty(this.listDirectory());
    }

    @Override
    public long getSize() {
        return this.getFile().length();
    }

    @Override
    public void dispose() throws IOException {
        FileUtil.deleteAll(this.getLocalFile(), true);
    }

    @Override
    public long saveContent(InputStream in) throws IOException {
        long result = -1L;
        try (BufferedOutputStream out = new BufferedOutputStream(this.getOutputStream());){
            result = StreamPumper.just().copyBytes(in, out);
        }
        return result;
    }

    @Override
    public FileOutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.getFile());
    }

    @Override
    public FileOutputStream getAppendingOutputStream() throws IOException {
        return new FileOutputStream(this.getFile(), true);
    }

    @Override
    public void copyContentTo(VirtualFile copy) throws IOException {
        try (InputStream in = this.getInputStream();){
            copy.saveContent(in);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.getFile()));
    }

    @Override
    public VirtualFile createFile(String name) throws IOException {
        if (!this.isDirectory()) {
            throw new IOException("File is not a directory!");
        }
        File newFile = new File(this.getFile(), name);
        this.createFileIfItDoesnotExist(newFile);
        return new LocalVirtualFile(newFile);
    }

    private void createFileIfItDoesnotExist(File newFile) throws IOException {
        if (!newFile.exists() && !newFile.createNewFile()) {
            throw new IOException("Could not create file:" + newFile.getAbsolutePath());
        }
    }

    @Override
    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.getFile().isFile();
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public Iterable<VirtualFile> listDirectory() {
        return this.listDirectory(null);
    }

    @Override
    public boolean exists() {
        File theFile = this.getFile();
        return null != theFile && theFile.exists();
    }

    @Override
    public Iterable<VirtualFile> listDirectory(VirtualFileFilter filter) {
        File[] files;
        ArrayList<VirtualFile> virtualFiles = new ArrayList<VirtualFile>();
        for (File f : files = FileLister.listFiles(this.getFile(), pathname -> {
            if (null == filter) {
                return true;
            }
            return filter.accept(this.getChild(pathname.getName()));
        })) {
            virtualFiles.add(this.getChild(f.getName()));
        }
        return virtualFiles;
    }

    @Override
    public String getName() {
        return this.getFile().getName();
    }

    @Override
    public String getAbsoluteName() {
        return this.getFile().getAbsolutePath();
    }

    @Override
    public VirtualFile getParent() {
        return new LocalVirtualFile(this.getFile().getParentFile());
    }

    @Override
    public VirtualFile getChild(String name) {
        return new LocalVirtualFile(new File(this.getFile(), name));
    }

    @Override
    public boolean hasChild(String name) {
        return new File(this.getFile(), name).exists();
    }

    public String toString() {
        return this.getAbsoluteName();
    }

    protected File getFile() {
        return this.file;
    }

    @Override
    public File getLocalFile() throws IOException {
        return this.getFile();
    }

    @Override
    public void disposeLocalFile(File localFile) throws IOException {
    }

    @Override
    public void mkdirs() throws IOException {
        this.getFile().mkdirs();
    }

    @Override
    public LocalVirtualFile createAsDirectory() throws IOException {
        FileUtil.ensureDirectoryTree(this.getFile(), false);
        return this;
    }

    @Override
    public String getCanonicalName() throws IOException {
        return this.getFile().getCanonicalPath();
    }

    public LocalVirtualFile withCreatedParentDirectories() throws IOException {
        this.getParent().createAsDirectory();
        return this;
    }

    @Override
    public URL getUrl() {
        try {
            return this.file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            this.getLogger().error("Could not get file URL", e);
            throw new IllegalStateException(e);
        }
    }

    public static Iterable<LocalVirtualFile> from(File ... files) {
        ArrayList<LocalVirtualFile> result = new ArrayList<LocalVirtualFile>();
        for (File each : files) {
            result.add(new LocalVirtualFile(each));
        }
        return result;
    }
}

