/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.virtual.feature;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.filter.VirtualFileFilter;
import com.schneide.base.io.virtual.readonly.ReadOnlyVirtualFile;
import com.schneide.base.io.virtual.readonly.ReadOnlyVirtualFileBase;
import com.schneide.base.threading.delay.Delay;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;

public class ReadOnlyFileDelayer
extends ReadOnlyVirtualFileBase {
    private final Delay delay;
    private final ReadOnlyVirtualFile original;

    public ReadOnlyFileDelayer(ReadOnlyVirtualFile original, Delay delay) {
        this.original = original;
        this.delay = delay;
    }

    protected ReadOnlyVirtualFile decorated(ReadOnlyVirtualFile file) {
        return new ReadOnlyFileDelayer(file, this.delay);
    }

    protected Iterable<ReadOnlyVirtualFile> decorated(Iterable<? extends ReadOnlyVirtualFile> files) {
        ArrayList<ReadOnlyVirtualFile> result = new ArrayList<ReadOnlyVirtualFile>();
        for (ReadOnlyVirtualFile readOnlyVirtualFile : files) {
            result.add(this.decorated(readOnlyVirtualFile));
        }
        return result;
    }

    protected ReadOnlyVirtualFile original() {
        return this.original;
    }

    protected void delay() {
        this.delay.performComplete();
    }

    @Override
    public ReadOnlyVirtualFile getParent() {
        return this.decorated(this.original().getParent());
    }

    @Override
    public ReadOnlyVirtualFile getChild(String name) {
        return this.decorated(this.original().getChild(name));
    }

    @Override
    public boolean hasChild(String name) {
        this.delay();
        return this.original().hasChild(name);
    }

    @Override
    public String getName() {
        return this.original().getName();
    }

    @Override
    public String getAbsoluteName() {
        return this.original().getAbsoluteName();
    }

    public Iterable<ReadOnlyVirtualFile> listDirectory() {
        this.delay();
        return this.decorated(this.original().listDirectory());
    }

    public Iterable<ReadOnlyVirtualFile> listDirectory(VirtualFileFilter filter) {
        this.delay();
        return this.decorated(this.original().listDirectory(filter));
    }

    @Override
    public boolean isDirectory() {
        return this.original().isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.original().isFile();
    }

    @Override
    public boolean isLocal() {
        return this.original().isLocal();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.delay();
        return this.original().getInputStream();
    }

    @Override
    public File getLocalFile() throws IOException {
        this.delay();
        return this.original().getLocalFile();
    }

    @Override
    public void disposeLocalFile(File localFile) throws IOException {
        this.delay();
        this.original().disposeLocalFile(localFile);
    }

    @Override
    public boolean exists() {
        return this.original().exists();
    }

    @Override
    public void copyContentTo(VirtualFile copy) throws IOException {
        this.delay();
        this.original().copyContentTo(copy);
    }

    @Override
    public long getLastModified() {
        this.delay();
        return this.original().getLastModified();
    }

    @Override
    public long getSize() throws IOException {
        this.delay();
        return this.original().getSize();
    }

    @Override
    public boolean isEmptyDirectory() {
        this.delay();
        return this.original().isEmptyDirectory();
    }

    @Override
    public boolean canRead() {
        this.delay();
        return this.original().canRead();
    }

    @Override
    public boolean canWrite() {
        this.delay();
        return this.original().canWrite();
    }

    @Override
    public String getCanonicalName() throws IOException {
        return this.original().getCanonicalName();
    }

    @Override
    public URL getUrl() {
        return this.original().getUrl();
    }
}

