/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.tools;

import com.schneide.base.system.Base;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Scanner;

public final class IOCloser {
    private IOCloser() {
    }

    public static boolean close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                return IOCloser.logError("Writer", e);
            }
        }
        return true;
    }

    public static boolean close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                return IOCloser.logError("Closeable", e);
            }
        }
        return true;
    }

    private static boolean logError(String type, IOException e) {
        Base.getLogger(IOCloser.class).error("error when closing a " + type, e);
        return false;
    }

    public static boolean close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                return IOCloser.logError("Reader", e);
            }
        }
        return true;
    }

    public static boolean close(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                return IOCloser.logError("OutputStream", e);
            }
        }
        return true;
    }

    public static boolean close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                return IOCloser.logError("InputStream", e);
            }
        }
        return true;
    }

    public static boolean close(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException e) {
                return IOCloser.logError("Socket", e);
            }
        }
        return true;
    }

    public static boolean close(ServerSocket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException e) {
                return IOCloser.logError("ServerSocket", e);
            }
        }
        return true;
    }

    public static boolean close(Scanner scanner) {
        if (null != scanner) {
            scanner.close();
        }
        return true;
    }
}

