/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.stream.pump;

import com.schneide.base.io.stream.NullOutputStream;
import com.schneide.base.io.stream.provider.OutputStreamProvider;
import com.schneide.base.io.stream.pump.NullPumperProgressListener;
import com.schneide.base.io.stream.pump.PumperProgressListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamPumper {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final PumperProgressListener listener;

    private StreamPumper(PumperProgressListener listener) {
        this.listener = listener;
    }

    public static StreamPumper with(PumperProgressListener listener) {
        return new StreamPumper(listener);
    }

    public static StreamPumper just() {
        return new StreamPumper(new NullPumperProgressListener());
    }

    public long pumpBytes(long byteCount, InputStream source, OutputStream target) throws IOException {
        return this.pumpBytes(byteCount, source, target, 4096);
    }

    public long pumpBytes(long byteCount, InputStream source, OutputStream target, int bufferSize) throws IOException {
        int actuallyRead;
        byte[] buffer = new byte[bufferSize];
        long totalRead = 0L;
        for (long stillToRead = byteCount; stillToRead > 0L; stillToRead -= (long)actuallyRead) {
            int desiredRead = (int)Math.min(stillToRead, (long)buffer.length);
            actuallyRead = source.read(buffer, 0, desiredRead);
            target.write(buffer, 0, actuallyRead);
            this.listener.progressMade(source, target, totalRead += (long)actuallyRead);
        }
        return totalRead;
    }

    public String charStreamToString(InputStream source) throws IOException {
        StringBuilder result = new StringBuilder();
        long totalRead = 0L;
        int current = -1;
        while (-1 != (current = source.read())) {
            result.append((char)current);
            this.listener.progressMade(source, null, ++totalRead);
        }
        return result.toString();
    }

    public long copyBytes(InputStream source, OutputStreamProvider target) throws IOException {
        try (OutputStream output = target.stream();){
            long l = this.copyBytes(source, output);
            return l;
        }
    }

    public long copyBytes(InputStream source, OutputStream target) throws IOException {
        return this.copyBytes(source, target, 4096);
    }

    public long copyBytes(InputStream source, OutputStream target, int bufferSize) throws IOException {
        return this.copyBytes(source, target, new byte[bufferSize]);
    }

    public long copyBytes(InputStream source, OutputStream target, byte[] buffer) throws IOException {
        long totalRead = 0L;
        int read = -1;
        while ((read = source.read(buffer)) > 0) {
            target.write(buffer, 0, read);
            this.listener.progressMade(source, target, totalRead += (long)read);
        }
        return totalRead;
    }

    public long readToEnd(InputStream stream) throws IOException {
        return this.copyBytes(stream, () -> new NullOutputStream());
    }
}

