/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.reader;

import com.schneide.base.io.encoding.Encoding;
import com.schneide.base.io.virtual.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public final class LinesOf {
    private LinesOf() {
    }

    public static List<String> virtualFile(VirtualFile input) throws IOException {
        return LinesOf.virtualFile(input, Encoding.utf8());
    }

    public static List<String> virtualFile(VirtualFile input, Charset encoding) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(input.getInputStream(), encoding);){
            List<String> list = LinesOf.readFrom(() -> new Scanner(reader));
            return list;
        }
    }

    public static List<String> textFile(File input) throws IOException {
        try (Scanner scanner = new Scanner(input, "utf-8");){
            List<String> list = LinesOf.readFrom(() -> scanner);
            return list;
        }
    }

    public static List<String> string(String input) {
        return LinesOf.readFrom(() -> new Scanner(input));
    }

    protected static List<String> readFrom(ScannerProvider source) {
        try (Scanner scanner = source.scanner();){
            ArrayList<String> result = new ArrayList<String>();
            while (scanner.hasNextLine()) {
                result.add(scanner.nextLine());
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    private static interface ScannerProvider {
        public Scanner scanner();
    }
}

