/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.reader;

import com.schneide.base.logging.LoggedObject;
import com.schneide.base.threading.ThreadMutex;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Iterator;

public class LineReader
extends LoggedObject
implements Enumeration<String>,
Iterable<String>,
Iterator<String>,
Closeable {
    private final BufferedReader buffer;
    private final ThreadMutex readLock;
    private boolean wasFetched;
    private String nextLine;
    private boolean omitEmptyLines;
    private boolean omitWhitespaceLines;

    public LineReader(Reader reader) {
        this.buffer = new BufferedReader(reader);
        this.readLock = new ThreadMutex();
        this.wasFetched = false;
        this.omitEmptyLines = false;
        this.omitWhitespaceLines = false;
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasNextLine();
    }

    @Override
    public boolean hasNext() {
        return this.hasNextLine();
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public String next() {
        return this.getNextLine();
    }

    @Override
    public String nextElement() {
        return this.getNextLine();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported by LineReader.");
    }

    public void setOmitEmptyLines(boolean omitEmptyLines) {
        this.omitEmptyLines = omitEmptyLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNextLine() {
        ThreadMutex threadMutex = this.readLock;
        synchronized (threadMutex) {
            if (!this.wasFetched) {
                this.fetchNextLine();
            }
            return null != this.nextLine;
        }
    }

    private void fetchNextLine() {
        try {
            this.nextLine = this.buffer.readLine();
            this.wasFetched = true;
            if (null == this.nextLine) {
                return;
            }
            if (this.omitEmptyLines && this.nextLine.isEmpty()) {
                this.fetchNextLine();
            }
            if (this.omitWhitespaceLines && this.nextLine.trim().isEmpty()) {
                this.fetchNextLine();
            }
        }
        catch (IOException e) {
            this.getLogger().error("Could not read from data source", e);
            this.nextLine = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextLine() {
        ThreadMutex threadMutex = this.readLock;
        synchronized (threadMutex) {
            if (!this.wasFetched) {
                this.fetchNextLine();
            }
            this.wasFetched = false;
            return this.nextLine;
        }
    }

    public void setOmitWhitespaceLines(boolean isOmittingWhitespaceLines) {
        this.omitWhitespaceLines = isOmittingWhitespaceLines;
    }
}

