/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.reader;

import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.text.buffer.DirectChunkBuffer;

public class LineBuilder
extends LoggedObject {
    private final DirectChunkBuffer buffer;

    public static String getPlatformLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static LineBuilder mit(String ... zeilen) {
        LineBuilder result = new LineBuilder();
        for (String each : zeilen) {
            result.addLine(each);
        }
        return result;
    }

    public LineBuilder() {
        this(LineBuilder.getPlatformLineSeparator());
    }

    public LineBuilder(String lineSeparator) {
        this.buffer = new DirectChunkBuffer(lineSeparator);
    }

    public String getLineSeparator() {
        return this.buffer.getSeparator();
    }

    public String getText() {
        return this.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.buffer.toString());
        if (!this.buffer.isEmpty()) {
            result.append(this.getLineSeparator());
        }
        return result.toString();
    }

    public void addLine(I18NResolvable i18n) {
        this.addLine(i18n.resolvedText());
    }

    public void addLine(String line) {
        this.buffer.add(line);
    }

    public void addLine() {
        this.addLine("");
    }
}

