/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.filter;

import com.schneide.base.i18n.I18NKey;
import java.io.File;
import java.io.FileFilter;

public class ImageFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private static final String[] ACCEPTED_SUFFIXES = new String[]{".png", ".jpg", ".jpeg", ".gif"};
    private final boolean includeDirectories;

    public ImageFileFilter(boolean includeDirectories) {
        this.includeDirectories = includeDirectories;
    }

    @Override
    public boolean accept(File f) {
        if (this.includeDirectories && f.isDirectory()) {
            return true;
        }
        return f.isFile() && this.hasAnAcceptableSuffix(f);
    }

    private boolean hasAnAcceptableSuffix(File f) {
        for (String suffix : ACCEPTED_SUFFIXES) {
            if (!f.getName().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return new I18NKey("imagefile.type").resolvedText();
    }
}

