/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.file;

import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.text.parsing.StringChunker;
import com.schneide.base.util.EqualsBuilder;

public final class Filename
implements EqualsBuilder.EqualComparable {
    private final String name;

    public Filename(String name) {
        this.name = name;
    }

    public static String withoutExtension(String filename) {
        if (!filename.contains(".")) {
            return filename;
        }
        StringChunker chunker = new StringChunker(filename, ".");
        String extension = chunker.getLastChunk();
        return filename.substring(0, filename.length() - (extension.length() + 1));
    }

    public Filename withoutExtension() {
        return new Filename(Filename.withoutExtension(this.name()));
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }

    public int hashCode() {
        return EqualsBuilder.hashCodeFor(this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.isEqual(this, obj);
    }

    public Iterable<Object> getValuesToCompare() {
        return new SingleElementIterable<Object>(this.name);
    }
}

