/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.file;

import com.schneide.base.io.file.FileLister;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.local.LocalVirtualFile;
import com.schneide.base.logging.Logger;
import com.schneide.base.system.Base;
import com.schneide.base.util.Parameter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.function.Supplier;

public final class FileLocator {
    private FileLocator() {
    }

    public static VirtualFile getFile(VirtualFile directory, String relativePath) {
        return new LocalVirtualFile(FileLocator.getFile(directory.getName() + "/" + relativePath));
    }

    public static File fileAt(Supplier<VirtualFile> directory, String relativePath) throws IOException {
        return FileLocator.getFile(directory.get(), relativePath).getLocalFile();
    }

    public static VirtualFile atPath(String relativePath) {
        return new LocalVirtualFile(FileLocator.getFile(relativePath));
    }

    public static File getFile(String relativePath) {
        return FileLocator.getFile(relativePath, false);
    }

    public static File getFile(String relativePath, boolean failSilently) {
        block4: {
            try {
                return FileLocator.getFileFromPath(relativePath);
            }
            catch (URISyntaxException e) {
                if (!failSilently) {
                    FileLocator.getLogger().warn("URI for " + relativePath + " is broken, using relative path.", e);
                }
            }
            catch (FileNotFoundException e) {
                Parameter.isPresent(e);
                if (failSilently) break block4;
                FileLocator.getLogger().info("File " + relativePath + " not found in classpath, using relative path.");
            }
        }
        return new File(relativePath);
    }

    private static File getFileFromPath(String path) throws URISyntaxException, FileNotFoundException {
        return FileLocator.getFileFromURL(ClassLoader.getSystemResource(path), path);
    }

    private static File getFileFromURL(URL url, String path) throws FileNotFoundException, URISyntaxException {
        if (null == url) {
            throw new FileNotFoundException("URL is null for resource path " + path);
        }
        return new File(url.toURI());
    }

    private static Logger getLogger() {
        return Base.getLogger(FileLocator.class);
    }

    public static File[] getAllOccurrencesOf(String[] relativePathes) {
        ArrayList<File> result = new ArrayList<File>();
        for (String string : relativePathes) {
            result.addAll(Arrays.asList(FileLocator.getAllOccurrencesOf(string)));
        }
        return result.toArray(new File[result.size()]);
    }

    public static File[] getAllOccurrencesOf(String relativePath) {
        try {
            Enumeration<URL> foundURLs = ClassLoader.getSystemResources(relativePath);
            ArrayList<File> result = new ArrayList<File>();
            while (foundURLs.hasMoreElements()) {
                try {
                    result.add(FileLocator.getFileFromURL(foundURLs.nextElement(), relativePath));
                }
                catch (URISyntaxException e) {
                    FileLocator.getLogger().error("Fehlerhafte URL ermittelt.", e);
                }
            }
            return result.toArray(new File[result.size()]);
        }
        catch (IOException e) {
            FileLocator.getLogger().error("Pfad nicht gefunden.", e);
            return new File[0];
        }
    }

    public static File[] getAllContentOf(String relativeFolderPath) {
        File[] folders = FileLocator.getAllOccurrencesOf(relativeFolderPath);
        ArrayList<File> result = new ArrayList<File>();
        for (File folder : folders) {
            result.addAll(Arrays.asList(FileLister.listFiles(folder)));
        }
        return result.toArray(new File[result.size()]);
    }

    public static String getRelativePathOfFile(File fileToResolve, File relativePath) {
        return relativePath.toURI().relativize(fileToResolve.toURI()).toASCIIString();
    }
}

