/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.compression;

import com.schneide.base.io.stream.provider.InputStreamProvider;
import com.schneide.base.text.Text;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZipperEntry {
    private final InputStreamProvider data;
    private final String zipPath;
    private final long length;
    private final String name;

    public ZipperEntry(File zipFile, String path) {
        this(new FileBasedInputStreamProvider(zipFile), zipFile.getName(), zipFile.length(), path);
    }

    public ZipperEntry(InputStreamProvider data, String name, long length, String path) {
        this.data = data;
        this.length = length;
        this.name = name;
        this.zipPath = path;
    }

    public long getLength() {
        return this.length;
    }

    public InputStream getInputStream() throws IOException {
        return this.data.stream();
    }

    public String getZipPath() {
        DirectChunkBuffer buffer = new DirectChunkBuffer("/");
        if (ZipperEntry.isRelevantPath(this.zipPath)) {
            buffer.add(this.zipPath);
        }
        buffer.add(this.name);
        return ((Object)buffer).toString();
    }

    private static boolean isRelevantPath(String zipPath) {
        return Text.hasContent(zipPath);
    }

    private static class FileBasedInputStreamProvider
    implements InputStreamProvider {
        private final File zipFile;

        public FileBasedInputStreamProvider(File zipFile) {
            this.zipFile = zipFile;
        }

        @Override
        public InputStream stream() throws IOException {
            return new FileInputStream(this.zipFile);
        }
    }
}

