/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.validation;

import com.schneide.base.datatypes.collections.CollectionUtil;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.validation.InputCollector;
import com.schneide.base.input.validation.ValidationAspect;
import com.schneide.base.input.validation.ValidationResult;
import com.schneide.base.input.validation.ValidationResultHolder;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;

public class Validator {
    public static final boolean VALID = true;
    public static final boolean INVALID = false;
    private final Container rootContainer;
    private final ValidationAspect[] additionalValidations;
    private final List<ValidationResult> validations;

    public Validator(Container content, ValidationAspect ... aspects) {
        this.rootContainer = content;
        this.additionalValidations = aspects;
        this.validations = new ArrayList<ValidationResult>();
    }

    public final boolean validate() {
        this.validations.clear();
        CollectionUtil.addAll(this.validations, this.getValidations());
        return this.examineValidationResults(this.validations);
    }

    public final Iterable<ValidationResult> getValidationResults() {
        return this.validations;
    }

    private boolean examineValidationResults(Iterable<ValidationResult> results) {
        boolean result = true;
        for (ValidationResult element : results) {
            if (element == null) continue;
            result &= element.isCorrect();
        }
        return result;
    }

    protected Iterable<ValidationResult> getValidations() {
        return this.collectValidations(this.gatherInputsFor(this.rootContainer));
    }

    private ValidationAspect[] getAdditionalValidationAspects() {
        return this.additionalValidations;
    }

    private Iterable<ValidationResult> collectValidations(Input[] inputs) {
        ArrayList<ValidationResult> currentValidations = new ArrayList<ValidationResult>();
        for (Input input : inputs) {
            CollectionUtil.addAll(currentValidations, input.validateInput());
        }
        for (ValidationAspect aspect : this.getAdditionalValidationAspects()) {
            ValidationResultHolder resultHolder = aspect.validate(inputs);
            if (resultHolder == null) {
                resultHolder = new ValidationResultHolder();
            }
            CollectionUtil.addAll(currentValidations, resultHolder.getResults());
        }
        return currentValidations;
    }

    private Input[] gatherInputsFor(Container root) {
        return new InputCollector().gatherInputsAsArray(root);
    }
}

