/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.validation;

import com.schneide.base.i18n.I18NKey;
import com.schneide.base.input.validation.ValidationAspect;
import com.schneide.base.input.validation.ValidationMessageType;
import com.schneide.base.input.validation.ValidationResult;
import com.schneide.base.input.validation.Validator;
import com.schneide.base.text.TextBuffer;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class SwingValidator
extends Validator {
    private final Component dialog;
    private static final ValidationMessageType[] CATEGORIES = new ValidationMessageType[]{ValidationMessageType.ERROR, ValidationMessageType.WARNING, ValidationMessageType.HINT, ValidationMessageType.INTERNAL};

    public SwingValidator(JDialog dialog, ValidationAspect ... validationAspects) {
        this((Component)dialog, dialog.getContentPane(), validationAspects);
    }

    public SwingValidator(JWindow window, ValidationAspect ... validationAspects) {
        this((Component)window, window.getContentPane(), validationAspects);
    }

    public SwingValidator(JPanel panel, ValidationAspect ... validationAspects) {
        this((Component)panel, panel, validationAspects);
    }

    private SwingValidator(Component parentDialog, Container contentPanel, ValidationAspect ... validationAspects) {
        super(contentPanel, validationAspects);
        this.dialog = parentDialog;
    }

    public boolean performSwingValidation() {
        boolean isValid = this.validate();
        this.showValidations();
        return isValid;
    }

    private Map<ValidationMessageType, List<ValidationResult>> createMessageMap(Iterable<ValidationResult> validations) {
        HashMap<ValidationMessageType, List<ValidationResult>> messageMap = new HashMap<ValidationMessageType, List<ValidationResult>>();
        block0: for (ValidationResult element : validations) {
            if (!element.needsDisplay()) continue;
            for (ValidationMessageType currentCategory : CATEGORIES) {
                if (!currentCategory.equals((Object)element.getMessageType())) continue;
                if (!messageMap.containsKey((Object)element.getMessageType())) {
                    messageMap.put(element.getMessageType(), new ArrayList());
                }
                ((List)messageMap.get((Object)element.getMessageType())).add(element);
                continue block0;
            }
        }
        return messageMap;
    }

    private void showValidations() {
        Map<ValidationMessageType, List<ValidationResult>> messageMap = this.createMessageMap(this.getValidationResults());
        if (messageMap.isEmpty()) {
            return;
        }
        TextBuffer buffer = new TextBuffer();
        ValidationMessageType mostSeverePresentMessageType = null;
        for (ValidationMessageType element : CATEGORIES) {
            List<ValidationResult> messages = messageMap.get((Object)element);
            if (null == messages || messages.isEmpty()) continue;
            if (null == mostSeverePresentMessageType) {
                mostSeverePresentMessageType = element;
            }
            buffer.append(this.getMessageFor(messages.iterator()));
        }
        JOptionPane.showMessageDialog(this.dialog, buffer.toString(), new I18NKey("SwingValidator.result.dialog.title").resolvedText(), this.getOptionPaneMessageType(mostSeverePresentMessageType));
    }

    protected int getOptionPaneMessageType(ValidationMessageType messageType) {
        if (null == messageType) {
            return -1;
        }
        return messageType.getMessageType();
    }

    private String getMessageFor(Iterator<ValidationResult> iter) {
        if (!iter.hasNext()) {
            return "";
        }
        TextBuffer buffer = new TextBuffer();
        ValidationResult firstElement = iter.next();
        buffer.add(firstElement.getCategoryMessage());
        buffer.addln(":");
        buffer.addln(firstElement.getMessage());
        while (iter.hasNext()) {
            buffer.addln(iter.next().getMessage());
        }
        buffer.addln();
        return buffer.toString();
    }
}

