/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.types.generic;

import com.schneide.base.datatypes.collections.CollectionUtil;
import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.input.i18n.Localisation;
import com.schneide.base.input.inputs.generic.CleanupRequiringInput;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.types.generic.ValueChangeListener;
import com.schneide.base.input.types.i18n.DirectValueInformation;
import com.schneide.base.input.types.i18n.ValueInformation;
import com.schneide.base.input.types.validation.ValueValidator;
import com.schneide.base.input.validation.EmptyInputResult;
import com.schneide.base.input.validation.IgnoredInputResult;
import com.schneide.base.input.validation.ValidInputResult;
import com.schneide.base.input.validation.ValidationResult;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.text.Text;
import com.schneide.base.threading.ThreadMutex;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public abstract class ValueBase
extends LoggedObject
implements Value {
    private Input source;
    private final ValueInformation valueInformation;
    private String widgetName;
    private Object originalValue;
    private boolean canBeEmpty;
    private boolean isEditable;
    private boolean needsFocus;
    private final List<ValueChangeListener> valueChangeListenerList;
    private final ThreadMutex listenerListLock;
    private final List<ValueValidator<? extends Value, ? extends Input>> additionalValidators;
    private final ThreadMutex validatorsLock;

    protected ValueBase(String title, String description, Object originalValue) {
        this(new DirectValueInformation(title, description), originalValue);
    }

    protected ValueBase(String title, String description, Object originalValue, boolean canBeEmpty) {
        this(new DirectValueInformation(title, description), originalValue, canBeEmpty);
    }

    protected ValueBase(ValueInformation valueInfo, Object originalValue) {
        this(valueInfo, originalValue, false);
    }

    protected ValueBase(ValueInformation valueInfo, Object originalValue, boolean canBeEmpty) throws IllegalArgumentException {
        if (null == valueInfo) {
            throw new IllegalArgumentException("Need to have a value information object instead of null.");
        }
        this.valueInformation = valueInfo;
        this.originalValue = originalValue;
        this.widgetName = null;
        this.canBeEmpty = canBeEmpty;
        this.isEditable = true;
        this.needsFocus = false;
        this.valueChangeListenerList = new ArrayList<ValueChangeListener>();
        this.listenerListLock = new ThreadMutex();
        this.additionalValidators = new ArrayList<ValueValidator<? extends Value, ? extends Input>>();
        this.validatorsLock = new ThreadMutex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
        ThreadMutex threadMutex = this.listenerListLock;
        synchronized (threadMutex) {
            if (listener != null) {
                if (this.valueChangeListenerList.size() == 0) {
                    this.switchChangeListener(true);
                }
                this.valueChangeListenerList.add(listener);
            }
        }
    }

    private void switchChangeListener(boolean isConnected) {
        if (this.hasSource()) {
            this.getSource().setRealtimeSupervision(isConnected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeValueChangeListener(ValueChangeListener listener) {
        ThreadMutex threadMutex = this.listenerListLock;
        synchronized (threadMutex) {
            if (listener != null) {
                this.valueChangeListenerList.remove(listener);
                if (this.valueChangeListenerList.size() == 0) {
                    this.switchChangeListener(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChangeListeners() {
        ThreadMutex threadMutex = this.listenerListLock;
        synchronized (threadMutex) {
            return this.valueChangeListenerList.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRealtimeSupervised() {
        ThreadMutex threadMutex = this.listenerListLock;
        synchronized (threadMutex) {
            return this.hasChangeListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyValueChanged() {
        ThreadMutex threadMutex = this.listenerListLock;
        synchronized (threadMutex) {
            for (ValueChangeListener valueChangeListener : this.valueChangeListenerList) {
                valueChangeListener.valueChanged(this);
            }
        }
    }

    @Override
    public void setSource(Input input) {
        input.setInputText(this.getCurrentValueRepresentation());
        this.source = input;
        this.adjustWidgetNameFor(this.source);
        this.source.setEnabled(this.isEditable);
        if (this.hasChangeListeners()) {
            this.switchChangeListener(true);
        }
        if (this.needsFocus) {
            this.setFocused();
        }
        input.showRequired(!this.canBeEmpty());
    }

    protected void adjustWidgetNameFor(Input currentSource) {
        if (null == this.widgetName) {
            return;
        }
        currentSource.setName(this.widgetName);
    }

    protected abstract String getCurrentValueRepresentation();

    @Override
    public boolean isValidInput(String text) {
        for (ValidationResult validationResult : this.validate()) {
            if (validationResult.isCorrect()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Iterable<ValidationResult> validate() {
        if (this.getSource().canBeEdited()) {
            return this.validateEditableInput();
        }
        return new SingleElementIterable<ValidationResult>(new IgnoredInputResult(this.getSource()));
    }

    protected Iterable<ValidationResult> validateEditableInput() {
        String text = this.getSource().getText();
        if (Text.isEmpty(text)) {
            return this.validateEmptyText();
        }
        ArrayList<ValidationResult> resultList = new ArrayList<ValidationResult>();
        CollectionUtil.addAll(resultList, this.internalValidation());
        CollectionUtil.addAll(resultList, this.additionalValidation());
        return resultList;
    }

    protected Iterable<ValidationResult> validateEmptyText() {
        if (this.canBeEmpty()) {
            return new SingleElementIterable<ValidationResult>(new ValidInputResult(this.getSource()));
        }
        return new SingleElementIterable<ValidationResult>(new EmptyInputResult(this.getSource()));
    }

    protected abstract Iterable<ValidationResult> internalValidation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Iterable<ValidationResult> additionalValidation() {
        ThreadMutex threadMutex = this.validatorsLock;
        synchronized (threadMutex) {
            ArrayList<ValidationResult> resultList = new ArrayList<ValidationResult>();
            for (ValueValidator<? extends Value, ? extends Input> validator : this.additionalValidators) {
                try {
                    resultList.add(validator.validate(this, this.getSource()));
                }
                catch (ClassCastException e) {
                    this.getLogger().warn("Wrong types expected at validation of " + String.valueOf(this) + " from validator " + String.valueOf(validator), e);
                }
            }
            return resultList;
        }
    }

    public boolean hasSource() {
        return null != this.getSource();
    }

    @Override
    public Input getSource() {
        return this.source;
    }

    @Override
    public abstract String getRestrictionDescription();

    @Override
    public String getFullDescription() {
        StringBuffer result = new StringBuffer();
        result.append("<HTML><B>");
        result.append(this.getDescription());
        result.append("</B><BR>");
        result.append(this.getInputTypeDescription());
        result.append(": ");
        result.append(this.getRestrictionDescription());
        if (this.hasUnitString()) {
            result.append(" (");
            result.append(Localisation.getLocalizedString("value.fulldescription.unit"));
            result.append(" ");
            result.append(this.getUnitString());
            result.append(")");
        }
        if (this.canBeEmpty()) {
            result.append(" <I>(");
            result.append(Localisation.getLocalizedString("value.fulldescription.optional"));
            result.append(")</I>");
        }
        result.append("</HTML>");
        return result.toString();
    }

    private String getInputTypeDescription() {
        if (this.getSource() != null && this.getSource().canBeEdited()) {
            return this.getSource().getActionDescription();
        }
        return Localisation.getLocalizedString("value.action.description");
    }

    @Override
    public abstract String getUnitString();

    @Override
    public boolean hasUnitString() {
        return this.getUnitString() != null && this.getUnitString().length() > 0;
    }

    @Override
    public String getTitle() {
        return this.valueInformation.getTitle();
    }

    @Override
    public String getHelpContextID() {
        return this.valueInformation.getHelpContext();
    }

    @Override
    public Component getComponent() {
        return this.getSource().getInputComponent();
    }

    @Override
    public String getDescription() {
        return this.valueInformation.getDescription();
    }

    @Override
    public Object getOriginalValue() {
        return this.originalValue;
    }

    protected void setOriginalValueIfNoSource(Object newOriginalValue) {
        if (!this.hasSource()) {
            this.originalValue = newOriginalValue;
        }
    }

    protected boolean hasOriginalValue() {
        return this.getOriginalValue() != null;
    }

    @Override
    public abstract String getTextualValue();

    @Override
    public boolean canBeEmpty() {
        return this.canBeEmpty;
    }

    @Override
    public void setCanBeEmpty(boolean canBeEmpty) {
        this.canBeEmpty = canBeEmpty;
        if (this.hasSource()) {
            this.getSource().showRequired(!this.canBeEmpty());
        }
    }

    @Override
    public void setInputText(String text) {
        if (text != null && this.hasSource()) {
            this.getSource().setInputText(text);
        }
    }

    @Override
    public boolean isEditable() {
        if (this.hasSource()) {
            return this.getSource().canBeEdited();
        }
        return this.isEditable;
    }

    @Override
    public void setEditable(boolean newState) {
        if (this.hasSource()) {
            this.getSource().setEnabled(newState);
        }
        this.isEditable = newState;
    }

    protected static String determineUnit(ValueInformation valueInformation, String explicitUnit) {
        String result = "";
        if (valueInformation.hasUnit()) {
            result = valueInformation.getUnit();
        }
        if (null != explicitUnit) {
            result = explicitUnit;
        }
        return result;
    }

    public static void setOptional(ValueBase ... values) {
        for (ValueBase value : values) {
            value.setCanBeEmpty(true);
        }
    }

    public void setFocused() {
        if (this.hasSource()) {
            this.getSource().getInputComponent().requestFocus();
            this.getSource().getInputComponent().requestFocusInWindow();
        }
        this.needsFocus = true;
    }

    public void cleanup() {
        if (!this.hasSource()) {
            return;
        }
        if (this.getSource() instanceof CleanupRequiringInput) {
            ((CleanupRequiringInput)((Object)this.getSource())).cleanup();
        }
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    public void setWidgetName(String newWidgetName) {
        this.widgetName = newWidgetName;
        if (this.hasSource()) {
            this.getSource().setName(newWidgetName);
        }
    }
}

