/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.types.generic;

import com.schneide.base.datatypes.collections.iterable.EmptyIterable;
import com.schneide.base.input.types.generic.KeyProvider;
import com.schneide.base.util.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Associations<X> {
    private final Map<String, X> map;
    private final List<String> list;

    public static <T extends Enum<T>> Associations<T> createFor(T[] enumInstances) {
        return Associations.createFor(enumInstances, (T value) -> value.toString());
    }

    public static <T> Associations<T> createFor(Stream<T> objects, KeyProvider<T> keyProvider) {
        return Associations.createFor(objects.collect(Collectors.toList()), keyProvider);
    }

    public static <T> Associations<T> createFor(Iterable<T> objects, KeyProvider<T> keyProvider) {
        ArrayList<String> keys = new ArrayList<String>();
        for (T object : objects) {
            keys.add(keyProvider.getKeyFor(object));
        }
        return Associations.createFrom(keys.toArray(new String[keys.size()]), objects);
    }

    public static <T> Associations<T> createFor(T[] objects, KeyProvider<T> keyProvider) {
        return Associations.createFor(Arrays.asList(objects), keyProvider);
    }

    public static <T> Associations<T> createFrom(String[] keys, Iterable<T> objects) throws IllegalArgumentException {
        Parameter.arePresent(keys, objects);
        HashMap<String, T> associationMap = new HashMap<String, T>();
        Iterator<T> objectIterator = objects.iterator();
        for (int i = 0; i < keys.length; ++i) {
            if (!objectIterator.hasNext()) {
                throw new IllegalArgumentException("Association parameter array lengths differ.");
            }
            associationMap.put(keys[i], objectIterator.next());
        }
        if (objectIterator.hasNext()) {
            throw new IllegalArgumentException("Association parameter array lengths differ.");
        }
        return new Associations(associationMap, keys);
    }

    public static <T> Associations<T> createFrom(Collection<String> keys, Collection<T> objects) throws IllegalArgumentException {
        Parameter.arePresent(keys, objects);
        return Associations.createFrom(keys.toArray(new String[keys.size()]), objects);
    }

    public static <T> Associations<T> createFrom(String[] keys, T[] objects) throws IllegalArgumentException {
        return Associations.createFrom(keys, Arrays.asList(objects));
    }

    public static <T> Associations<T> createEmpty() {
        return Associations.createFrom(new String[0], new EmptyIterable());
    }

    public Associations(Map<String, X> filledMap, Iterable<String> keys) {
        this.map = filledMap;
        this.list = new ArrayList<String>();
        for (String string : keys) {
            this.list.add(string);
        }
    }

    public Associations(Map<String, X> filledMap, String[] keys) {
        this(filledMap, Arrays.asList(keys));
    }

    public Associations() {
        this(new HashMap(), new String[0]);
    }

    public synchronized void sort() {
        Collections.sort(this.list);
    }

    public synchronized void sort(Comparator<String> keyComparator) {
        Collections.sort(this.list, keyComparator);
    }

    public synchronized String[] getKeys() {
        return this.list.toArray(new String[this.list.size()]);
    }

    public synchronized boolean hasKey(String key) {
        return this.map.containsKey(key);
    }

    public synchronized boolean hasValue(X value) {
        return this.map.containsValue(value);
    }

    public synchronized String getKeyFor(X value) throws NoSuchElementException {
        if (null == value) {
            throw new NoSuchElementException("The object null definitly has no key.");
        }
        Set<Map.Entry<String, X>> pairEntries = this.map.entrySet();
        for (Map.Entry<String, X> element : pairEntries) {
            if (!value.equals(element.getValue())) continue;
            return element.getKey();
        }
        System.out.println(value.getClass());
        throw new NoSuchElementException("Could not find key for object " + String.valueOf(value));
    }

    public synchronized X getValueFor(String key) throws NoSuchElementException {
        return this.map.get(key);
    }

    public synchronized int addValue(String key, X value) {
        return this.addValue(key, value, this.list.size());
    }

    public synchronized int addValue(String key, X value, int position) {
        this.map.put(key, value);
        this.list.add(position, key);
        return position;
    }

    public synchronized void addValues(Associations<X> otherAssociations) {
        for (String key : otherAssociations.getKeys()) {
            this.addValue(key, otherAssociations.getValueFor(key));
        }
    }
}

