/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.types;

import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.i18n.DirectText;
import com.schneide.base.input.datatypes.IntegerValueRange;
import com.schneide.base.input.i18n.Localisation;
import com.schneide.base.input.inputs.InputFactory;
import com.schneide.base.input.inputs.SpinnerInput;
import com.schneide.base.input.inputs.generic.BoundAwareInput;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.types.generic.NumericValue;
import com.schneide.base.input.types.generic.ValueBase;
import com.schneide.base.input.types.i18n.ValueInformation;
import com.schneide.base.input.validation.InvalidInputResult;
import com.schneide.base.input.validation.ValidInputResult;
import com.schneide.base.input.validation.ValidationResult;
import com.schneide.base.util.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;

public class IntegerValue
extends ValueBase
implements NumericValue {
    private DecimalFormat formatter = null;
    private IntegerValueRange bounds;
    private String unitString;
    private int lastValue;

    public IntegerValue(ValueInformation valueInfo) {
        this(valueInfo, null, new IntegerValueRange(), null);
    }

    public IntegerValue(ValueInformation valueInfo, Integer originalValue) {
        this(valueInfo, originalValue, (String)null);
    }

    public IntegerValue(ValueInformation valueInfo, String unitString) {
        this(valueInfo, null, new IntegerValueRange(), unitString);
    }

    public IntegerValue(ValueInformation valueInfo, Integer originalValue, String unitString) {
        this(valueInfo, originalValue, new IntegerValueRange(), unitString);
    }

    public IntegerValue(ValueInformation valueInfo, IntegerValueRange valueRange) {
        this(valueInfo, null, valueRange, null);
    }

    public IntegerValue(ValueInformation valueInfo, int originalValue, IntegerValueRange valueRange) {
        this(valueInfo, originalValue, valueRange, null);
    }

    public IntegerValue(ValueInformation valueInfo, IntegerValueRange valueRange, String unitString) {
        this(valueInfo, null, valueRange, unitString);
    }

    protected IntegerValue(ValueInformation valueInfo, Integer originalValue, IntegerValueRange valueRange, String unitString) {
        super(valueInfo, originalValue);
        this.bounds = valueRange;
        this.unitString = ValueBase.determineUnit(valueInfo, unitString);
        if (this.hasOriginalValue()) {
            this.lastValue = originalValue;
        }
    }

    public void setValueRange(IntegerValueRange newBounds) {
        this.bounds = newBounds;
        Input currentInput = this.getSource();
        if (null != currentInput && currentInput instanceof BoundAwareInput) {
            ((BoundAwareInput)((Object)currentInput)).adjustBounds();
        }
    }

    public IntegerValue withRange(IntegerValueRange newBounds) {
        this.setValueRange(newBounds);
        return this;
    }

    @Override
    protected Iterable<ValidationResult> internalValidation() {
        try {
            this.lastValue = this.getValue(true);
            if (this.bounds.isValueInRange(this.lastValue)) {
                return new SingleElementIterable<ValidationResult>(new ValidInputResult(this.getSource()));
            }
            return new SingleElementIterable<ValidationResult>(new InvalidInputResult(this.getSource(), new DirectText(Localisation.getLocalizedString("value.error.rangeExceeded") + this.bounds.getFullDescription())));
        }
        catch (NumberFormatException e) {
            Parameter.isPresent(e);
            return new SingleElementIterable<ValidationResult>(new InvalidInputResult(this.getSource(), Localisation.getLocalizedText("value.integer.error.invalidInput")));
        }
    }

    public int getValue() {
        return this.getValue(false);
    }

    public int getValue(boolean internalAccess) throws NumberFormatException {
        try {
            if (this.hasSource()) {
                this.ensureSource();
                this.lastValue = Integer.parseInt(this.getSource().getText());
            } else {
                this.lastValue = (Integer)this.getOriginalValue();
            }
            return this.lastValue;
        }
        catch (RuntimeException e) {
            try {
                this.ensureSource();
                BigDecimal decimal = new BigDecimal(this.getSource().getText());
                BigInteger integer = decimal.toBigInteger();
                BigDecimal compare = new BigDecimal(integer);
                if (decimal.compareTo(compare) == 0) {
                    this.lastValue = integer.intValue();
                    return this.lastValue;
                }
            }
            catch (NumberFormatException e1) {
                if (internalAccess) {
                    throw e1;
                }
                return this.lastValue;
            }
            if (internalAccess) {
                throw e;
            }
            return this.lastValue;
        }
    }

    private void ensureSource() throws NumberFormatException {
        if (null == this.getSource()) {
            throw new NumberFormatException(Localisation.getLocalizedString("errormessage.noboundinput"));
        }
    }

    public IntegerValueRange getBounds() {
        return this.bounds;
    }

    @Override
    public String getRestrictionDescription() {
        StringBuffer result = new StringBuffer();
        result.append(Localisation.getLocalizedString("value.integer.input.description"));
        result.append(this.bounds.getIntuitiveDescription());
        return result.toString();
    }

    @Override
    public String getUnitString() {
        return this.unitString;
    }

    public int getLowerBound() {
        return this.bounds.getLowerBound();
    }

    public int getUpperBound() {
        return this.bounds.getUpperBound();
    }

    @Override
    public boolean hasLowerBound() {
        return this.bounds.hasLowerRestriction();
    }

    @Override
    public boolean hasUpperBound() {
        return this.bounds.hasUpperRestriction();
    }

    public void setValue(int value) {
        this.setValue(value, this.getFormatter());
    }

    public void setValue(int value, DecimalFormat usedFormatter) {
        this.setOriginalValueIfNoSource(value);
        this.setInputText(this.getFormattedValue(value, usedFormatter));
    }

    @Override
    protected String getCurrentValueRepresentation() {
        return this.getTextualValue();
    }

    @Override
    public String getTextualValue() {
        try {
            return this.getFormattedValue(this.getValue(true), this.getFormatter());
        }
        catch (NumberFormatException e) {
            Parameter.isPresent(e);
            return "";
        }
    }

    protected final String getFormattedValue(int value, DecimalFormat usedFormatter) {
        if (null == usedFormatter) {
            return String.valueOf(value);
        }
        return usedFormatter.format(value);
    }

    public DecimalFormat getFormatter() {
        return this.formatter;
    }

    public void setFormatter(DecimalFormat formatter) {
        this.formatter = formatter;
    }

    @Override
    @Deprecated
    public Input createNaturalInput() {
        return new SpinnerInput(this);
    }

    public void setUnitString(String unitString) {
        this.unitString = unitString;
    }

    @Override
    public Input createNaturalInput(InputFactory factory) {
        return this.createNaturalInput();
    }
}

