/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.types;

import com.schneide.base.input.types.QuantityValue;
import com.schneide.base.input.types.i18n.ValueInformation;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;

public class ExactQuantityValue<Q extends Quantity>
extends QuantityValue<Q> {
    public ExactQuantityValue(ValueInformation information, Unit<Q> unit, Amount<Q> initialValue) throws IllegalArgumentException {
        super(information, unit, initialValue);
        this.ensureExactnessOf(initialValue);
    }

    private boolean isAmountExact(Amount<Q> value) {
        return null == value || value.isExact();
    }

    private void ensureExactnessOf(Amount<Q> value) {
        if (!this.isAmountExact(value)) {
            throw new IllegalArgumentException("You need to provide an exact amount of " + String.valueOf(this.getUnit()) + " instead of " + String.valueOf(value));
        }
    }

    public ExactQuantityValue(ValueInformation information, Unit<Q> unit, Long initialValue) throws IllegalArgumentException {
        this(information, unit, ExactQuantityValue.getAmountFor(initialValue, unit));
    }

    private static <Q extends Quantity> Amount<Q> getAmountFor(Long initialValue, Unit<Q> unit) {
        if (null == initialValue) {
            return null;
        }
        return Amount.valueOf((long)initialValue, unit);
    }

    @Override
    protected String getFormattedValueFor(Amount<Q> toFormat) {
        if (null == toFormat) {
            return super.getFormattedValueFor(null);
        }
        return this.getFormatter().format(toFormat.longValue(this.getUnit()));
    }

    @Override
    public void setValue(Amount<Q> newValue) {
        this.ensureExactnessOf(newValue);
        super.setValue(newValue);
    }

    @Override
    protected Amount<Q> parseFromInput() throws NumberFormatException {
        return Amount.valueOf((long)Long.parseLong(this.retrieveParseableSourceText()), this.getUnit());
    }
}

