/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.types;

import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.datetime.util.DateUtil;
import com.schneide.base.input.i18n.Localisation;
import com.schneide.base.input.inputs.InputFactory;
import com.schneide.base.input.inputs.SpinnerInput;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.types.generic.ValueBase;
import com.schneide.base.input.types.i18n.EmptyValueInformation;
import com.schneide.base.input.types.i18n.ValueInformation;
import com.schneide.base.input.validation.InvalidInputResult;
import com.schneide.base.input.validation.ValidInputResult;
import com.schneide.base.input.validation.ValidationResult;
import com.schneide.base.programming.NotYetImplementedException;
import com.schneide.base.system.Base;
import com.schneide.base.util.Parameter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Optional;
import org.joda.time.DateTime;

public class DateValue
extends ValueBase {
    private DateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
    private final String unitString;
    private Date lastValue;

    public DateValue() {
        this(new EmptyValueInformation());
    }

    public DateValue(ValueInformation information) {
        this(information, (Date)null);
    }

    public DateValue(ValueInformation information, LocalDate original, ZoneId zeitzone) {
        this(information, original == null ? null : original.atStartOfDay(zeitzone));
    }

    public DateValue(ValueInformation information, ZonedDateTime original) {
        this(information, original == null ? null : Date.from(original.toInstant()));
    }

    public DateValue(ValueInformation information, Date originalValue) {
        this(information, originalValue, null);
    }

    protected DateValue(ValueInformation information, Date originalValue, String unitString) {
        super(information, originalValue);
        this.unitString = ValueBase.determineUnit(information, unitString);
        this.lastValue = null;
        if (this.hasOriginalValue()) {
            this.lastValue = originalValue;
        }
    }

    @Override
    protected Iterable<ValidationResult> internalValidation() {
        try {
            this.lastValue = this.getValue(true);
            return new SingleElementIterable<ValidationResult>(new ValidInputResult(this.getSource()));
        }
        catch (ParseException e) {
            Parameter.isPresent(e);
            return new SingleElementIterable<ValidationResult>(new InvalidInputResult(this.getSource(), Localisation.getLocalizedText("value.date.error.invalidInput")));
        }
    }

    @Override
    public boolean hasValue() {
        return null != this.lastValue;
    }

    public Date getStoredValue() {
        if (null == this.lastValue) {
            return null;
        }
        return new Date(this.lastValue.getTime());
    }

    public Date getValue() {
        try {
            return this.getValue(false);
        }
        catch (ParseException e) {
            Parameter.isPresent(e);
            Base.getLogger(this).fatal("Darf nicht passieren.", new Throwable());
            return null;
        }
    }

    public Optional<LocalDateTime> maybeValueAsLocalDateTime(ZoneId zeitzone) {
        return this.maybeValue().map(d -> d.toInstant().atZone(zeitzone).toLocalDateTime());
    }

    public Optional<Date> maybeValue() {
        String angabe = this.getSource().getText();
        if (angabe == null || angabe.isBlank()) {
            return Optional.empty();
        }
        try {
            Date result = this.getValue(false);
            return Optional.ofNullable(result);
        }
        catch (ParseException e) {
            return Optional.empty();
        }
    }

    public LocalDateTime getValuesAsLocalDateTime() {
        return DateUtil.javaLocalDateTimeFrom(this.getValueAsDateTime());
    }

    public DateTime getValueAsDateTime() {
        try {
            return new DateTime((Object)this.getValue(false));
        }
        catch (ParseException e) {
            Parameter.isPresent(e);
            Base.getLogger(this).fatal("Darf nicht passieren.", new Throwable());
            return null;
        }
    }

    public Date getValue(boolean internalAccess) throws ParseException {
        block5: {
            if (this.hasSource()) {
                try {
                    Date parsedDate;
                    this.ensureSource();
                    this.lastValue = parsedDate = this.getFormatter().parse(this.getSource().getText());
                }
                catch (ParseException e) {
                    if (!internalAccess) break block5;
                    throw e;
                }
            }
        }
        if (null == this.lastValue) {
            if (internalAccess) {
                throw new ParseException("", 0);
            }
            return new Date();
        }
        return this.getStoredValue();
    }

    @Override
    protected String getCurrentValueRepresentation() {
        if (!this.hasValue()) {
            return "";
        }
        return this.getDateRepresentation(this.getValue());
    }

    private void ensureSource() throws ParseException {
        if (this.getSource() == null) {
            throw new ParseException(Localisation.getLocalizedString("errormessage.noboundinput"), 0);
        }
    }

    @Override
    public String getRestrictionDescription() {
        StringBuffer result = new StringBuffer();
        result.append(Localisation.getLocalizedString("value.date.input.description"));
        return result.toString();
    }

    @Override
    public String getUnitString() {
        return this.unitString;
    }

    @Override
    public String getTextualValue() {
        try {
            return this.getDateRepresentation(this.getValue(true));
        }
        catch (ParseException e) {
            Parameter.isPresent(e);
            return this.getEmptyTextFromSource();
        }
    }

    protected String getEmptyTextFromSource() {
        Input input = this.getSource();
        if (null == input) {
            return null;
        }
        String inputText = input.getText();
        if (inputText.isEmpty() && this.canBeEmpty()) {
            return "";
        }
        return null;
    }

    private String getDateRepresentation(Date value) {
        if (this.hasFormatter()) {
            return this.getFormatter().format(value);
        }
        return String.valueOf(value);
    }

    public void setValue(Date value) {
        this.setOriginalValueIfNoSource(value);
        this.lastValue = null == value ? null : new Date(value.getTime());
        this.refreshTo(value);
    }

    public void refresh() {
        this.refreshTo(this.getValue());
    }

    protected void refreshTo(Date value) {
        String representation = this.getDateRepresentation(value);
        this.setInputText(representation);
    }

    public boolean hasFormatter() {
        return this.getFormatter() != null;
    }

    public void setValue(Date value, DateFormat newFormatter) {
        this.setFormatter(newFormatter);
        this.setValue(value);
    }

    public DateFormat getFormatter() {
        return this.formatter;
    }

    public void setFormatter(DateFormat formatter) {
        this.formatter = formatter;
    }

    @Override
    @Deprecated
    public Input createNaturalInput() {
        return new SpinnerInput(this);
    }

    @Override
    public Input createNaturalInput(InputFactory factory) {
        throw new NotYetImplementedException("createNaturalInput");
    }
}

