/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.types;

import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.input.datatypes.BooleanRepresentationPair;
import com.schneide.base.input.datatypes.GenericBooleanRepresentationPair;
import com.schneide.base.input.i18n.Localisation;
import com.schneide.base.input.inputs.CheckboxInput;
import com.schneide.base.input.inputs.InputFactory;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.inputs.modes.InternalStateBasedInput;
import com.schneide.base.input.types.generic.ValueBase;
import com.schneide.base.input.types.i18n.EmptyValueInformation;
import com.schneide.base.input.types.i18n.ValueInformation;
import com.schneide.base.input.validation.InvalidInputResult;
import com.schneide.base.input.validation.ValidInputResult;
import com.schneide.base.input.validation.ValidationResult;
import com.schneide.base.util.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class BooleanValue
extends ValueBase {
    private static final BooleanRepresentationPair[] DEFAULT_REPRESENTATIONS = new BooleanRepresentationPair[]{new GenericBooleanRepresentationPair("ja", "nein"), new GenericBooleanRepresentationPair("true", "false"), new GenericBooleanRepresentationPair("yes", "no"), new GenericBooleanRepresentationPair("wahr", "unwahr"), new GenericBooleanRepresentationPair("richtig", "falsch"), new GenericBooleanRepresentationPair("y", "n"), new GenericBooleanRepresentationPair("j", "n"), new GenericBooleanRepresentationPair("1", "0")};
    private boolean lastValue;
    private String lastTextualValue;
    private final Map<String, Boolean> stringMap;
    private final String mainTrueString;
    private final String mainFalseString;

    public BooleanValue() {
        this(new EmptyValueInformation());
    }

    public BooleanValue(ValueInformation information) {
        this(information, null);
    }

    public BooleanValue(ValueInformation information, Boolean originalValue) {
        this(information, originalValue, DEFAULT_REPRESENTATIONS);
    }

    public BooleanValue(ValueInformation information, Boolean originalValue, final I18NResolvable falseDenotation, final I18NResolvable trueDenotation) {
        this(information, originalValue, new BooleanRepresentationPair(){

            @Override
            public String getTrueRepresentation() {
                return trueDenotation.resolvedText();
            }

            @Override
            public String getFalseRepresentation() {
                return falseDenotation.resolvedText();
            }
        });
    }

    public BooleanValue(ValueInformation information, Boolean originalValue, BooleanRepresentationPair ... representations) {
        super(information, originalValue);
        this.stringMap = BooleanValue.createMapFrom(representations);
        this.mainTrueString = representations[0].getTrueRepresentation();
        this.mainFalseString = representations[0].getFalseRepresentation();
        if (this.hasOriginalValue()) {
            this.lastValue = originalValue;
            this.lastTextualValue = this.getTextualValueOf(originalValue);
        }
    }

    private String getTextualValueOf(boolean currentValue) {
        if (currentValue) {
            return this.mainTrueString;
        }
        return this.mainFalseString;
    }

    private static Map<String, Boolean> createMapFrom(BooleanRepresentationPair[] representations) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (BooleanRepresentationPair element : representations) {
            result.put(element.getTrueRepresentation().toLowerCase(), Boolean.TRUE);
            result.put(element.getFalseRepresentation().toLowerCase(), Boolean.FALSE);
        }
        return result;
    }

    private Map<String, Boolean> getRepresentationMap() {
        return this.stringMap;
    }

    @Override
    protected Iterable<ValidationResult> internalValidation() {
        try {
            this.lastValue = this.getValue();
            return new SingleElementIterable<ValidationResult>(new ValidInputResult(this.getSource()));
        }
        catch (NoSuchElementException e) {
            Parameter.isPresent(e);
            return new SingleElementIterable<ValidationResult>(new InvalidInputResult(this.getSource(), Localisation.getLocalizedText("value.boolean.error.invalidInput")));
        }
    }

    public boolean getValue(boolean internalAccess) throws NoSuchElementException {
        if (!this.hasSource()) {
            return this.getLastValue();
        }
        if (this.hasInternalStateBasedInput()) {
            return this.extractFromInternalStateBasedInput((InternalStateBasedInput)this.getSource());
        }
        return this.extractFromTextBasedInput(internalAccess, this.getSource());
    }

    private boolean extractFromTextBasedInput(boolean internalAccess, Input input) {
        this.lastTextualValue = input.getText();
        if (null == this.lastTextualValue) {
            return this.getLastValue();
        }
        if (this.getRepresentationMap().containsKey(this.lastTextualValue.toLowerCase())) {
            this.lastValue = this.getRepresentationMap().get(this.lastTextualValue.toLowerCase());
            return this.getLastValue();
        }
        if (!internalAccess) {
            return this.getLastValue();
        }
        throw new NoSuchElementException("Could not interpret given input value to a boolean.");
    }

    private boolean extractFromInternalStateBasedInput(InternalStateBasedInput input) {
        this.lastValue = input.isSelected();
        this.lastTextualValue = this.getTextualValueOf(this.lastValue);
        return this.getLastValue();
    }

    private boolean getLastValue() {
        return this.lastValue;
    }

    @Override
    protected String getCurrentValueRepresentation() {
        return this.lastTextualValue;
    }

    private boolean hasInternalStateBasedInput() {
        return this.getSource() instanceof InternalStateBasedInput;
    }

    public boolean getValue() {
        return this.getValue(false);
    }

    @Override
    public String getRestrictionDescription() {
        return Localisation.getLocalizedString("value.boolean.input.description");
    }

    @Override
    public String getUnitString() {
        return "";
    }

    public void setValue(boolean value) {
        this.setOriginalValueIfNoSource(value);
        if (this.hasSource()) {
            if (this.hasInternalStateBasedInput()) {
                ((InternalStateBasedInput)this.getSource()).setSelected(value);
            } else {
                String inputText = value ? this.getMainTrueString() : this.getMainFalseString();
                this.getSource().setInputText(inputText);
            }
        }
    }

    @Override
    protected void setOriginalValueIfNoSource(Object newOriginalValue) {
        super.setOriginalValueIfNoSource(newOriginalValue);
        if (null != this.getOriginalValue()) {
            this.lastValue = (Boolean)this.getOriginalValue();
        }
    }

    @Override
    public String getTextualValue() {
        return this.getCurrentValueRepresentation();
    }

    public String getMainTrueString() {
        return this.mainTrueString;
    }

    public String getMainFalseString() {
        return this.mainFalseString;
    }

    public String[] getMainStrings() {
        return new String[]{this.getMainTrueString(), this.getMainFalseString()};
    }

    @Override
    @Deprecated
    public Input createNaturalInput() {
        return new CheckboxInput(this);
    }

    @Override
    public Input createNaturalInput(InputFactory factory) {
        return this.createNaturalInput();
    }
}

