/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.types;

import com.schneide.base.datatypes.collections.ArrayUtil;
import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.input.inputs.ComboboxInput;
import com.schneide.base.input.inputs.InputFactory;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.types.generic.Associations;
import com.schneide.base.input.types.generic.ValueBase;
import com.schneide.base.input.types.i18n.ValueInformation;
import com.schneide.base.input.validation.IgnoredInputResult;
import com.schneide.base.input.validation.InvalidInputResult;
import com.schneide.base.input.validation.ValidInputResult;
import com.schneide.base.input.validation.ValidationResult;
import com.schneide.base.util.Parameter;
import java.util.NoSuchElementException;
import java.util.Optional;

public class AssociationValue<TYPE>
extends ValueBase {
    protected static final boolean DEFAULT_STRICTNESS = true;
    private Associations<TYPE> associations;

    public AssociationValue(ValueInformation valueInfo, Associations<TYPE> associations) {
        this(valueInfo, null, associations);
    }

    public static <TYPE> AssociationValue<TYPE> f\u00fcr(ValueInformation valueInfo, Optional<TYPE> originalValue, Associations<TYPE> associations) {
        return new AssociationValue<Object>(valueInfo, originalValue.orElse(null), associations);
    }

    public AssociationValue(ValueInformation valueInfo, TYPE originalValue, Associations<TYPE> associations) {
        super(valueInfo, originalValue);
        this.associations = associations;
    }

    protected static void checkMapConstraints(String[] keys, Object[] values) throws IllegalArgumentException {
        if (ArrayUtil.isNull(keys)) {
            throw new IllegalArgumentException("the association key array is null");
        }
        if (ArrayUtil.isNull(values)) {
            throw new IllegalArgumentException("the association value array is null");
        }
        if (!ArrayUtil.isSameSize(keys, values)) {
            throw new IllegalArgumentException("the association values are of different sizes");
        }
    }

    @Override
    protected Iterable<ValidationResult> internalValidation() {
        if (!this.hasSource()) {
            return new SingleElementIterable<ValidationResult>(new IgnoredInputResult(this.getSource()));
        }
        String key = this.getInputText();
        if (!this.getAssociations().hasKey(key)) {
            return new SingleElementIterable<ValidationResult>(new InvalidInputResult(this.getSource(), new I18NKey("AssociationValue.input.invalid.message")));
        }
        return new SingleElementIterable<ValidationResult>(new ValidInputResult(this.getSource()));
    }

    public void appendAssociation(String key, TYPE value) {
        this.getAssociations().addValue(key, value);
    }

    public void prependAssocation(String key, TYPE value) {
        this.getAssociations().addValue(key, value, 0);
    }

    public boolean hasAssociation(String key) {
        return this.getAssociations().hasKey(key);
    }

    protected Associations<TYPE> getAssociations() {
        return this.associations;
    }

    protected String getInputText() {
        return EDT.query(() -> this.getSource().getText());
    }

    protected TYPE getInternalValue() {
        try {
            this.ensureSource();
            String key = this.getInputText();
            if (!this.getAssociations().hasKey(key)) {
                return this.handleUnassociatedKey(key);
            }
            return this.getAssociations().getValueFor(key);
        }
        catch (NullPointerException | NoSuchElementException e) {
            Parameter.isPresent(e);
            return this.getTypedOriginalValue();
        }
    }

    public Optional<TYPE> lookup(String key) {
        return Optional.ofNullable(this.getAssociations().getValueFor(key));
    }

    private TYPE getTypedOriginalValue() {
        return (TYPE)this.getOriginalValue();
    }

    protected TYPE handleUnassociatedKey(String key) {
        throw new NoSuchElementException("Could not find associated value for " + key);
    }

    public String getKeyOfValue() {
        try {
            this.ensureSource();
            return this.getInputText();
        }
        catch (NullPointerException e) {
            Parameter.isPresent(e);
            if (null == this.getTypedOriginalValue()) {
                return null;
            }
            return this.obtainKeyFor(this.getTypedOriginalValue());
        }
    }

    public String[] getKeys() {
        return this.getAssociations().getKeys();
    }

    private void ensureSource() throws NullPointerException {
        if (!this.hasSource()) {
            throw new NullPointerException("Keine gebundenes Eingabefeld vorhanden.");
        }
    }

    public void changeAssociations(Associations<TYPE> newAssociations) {
        this.associations = newAssociations;
        if (this.hasSource()) {
            this.getSource().refreshFromValue();
        }
    }

    @Override
    public String getRestrictionDescription() {
        return "Zugeordnete Zeichenkette";
    }

    @Override
    public String getUnitString() {
        return "";
    }

    public void setValue(TYPE value) {
        this.setInternalValue(value);
    }

    public void setValueByKey(String key) {
        if (!this.getAssociations().hasKey(key)) {
            this.handleUnassociatedKey(key);
        }
        this.setInternalValue(this.getAssociations().getValueFor(key));
    }

    protected void setInternalValue(TYPE value) {
        if (this.getAssociations().hasValue(value)) {
            String key = this.obtainKeyFor(value);
            this.setInputText(key);
        } else {
            this.setInputText(String.valueOf(value));
        }
        this.setOriginalValueIfNoSource(value);
    }

    private String obtainKeyFor(TYPE value) throws NoSuchElementException {
        return this.getAssociations().getKeyFor(value);
    }

    @Override
    protected String getCurrentValueRepresentation() {
        return String.valueOf(this.getInternalValue());
    }

    @Override
    public String getTextualValue() {
        return String.valueOf(this.getInternalValue());
    }

    @Override
    @Deprecated
    public Input createNaturalInput() {
        return new ComboboxInput(this);
    }

    @Override
    public Input createNaturalInput(InputFactory factory) {
        return factory.getComboboxInputFor(this);
    }

    public Optional<TYPE> maybeValue() {
        return Optional.ofNullable(this.getValue());
    }

    public TYPE getValue() {
        return this.getInternalValue();
    }

    public boolean isStrict() {
        return true;
    }
}

