/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.inputs.time;

import com.schneide.base.input.inputs.generic.BoundAwareInput;
import com.schneide.base.input.inputs.generic.GenericInputImplementation;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.inputs.layout.LayoutStrategy;
import com.schneide.base.input.inputs.modes.TextualBasedInput;
import com.schneide.base.input.types.DateValue;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.validation.ValidationResult;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXDatePicker;

public class DayChooserInput
extends JXDatePicker
implements Input,
TextualBasedInput,
BoundAwareInput {
    private static final long serialVersionUID = 7418897817918867227L;
    private final GenericInputImplementation inputImplementation;

    public DayChooserInput(DateValue value) {
        boolean needsClearance = !value.hasValue() && value.canBeEmpty();
        this.setDate(value.getValue());
        this.setFormats(new String[]{"dd.MM.yyyy"});
        this.inputImplementation = new GenericInputImplementation(this, value, (JComponent)((Object)this));
        value.setSource(this);
        this.adjustTooltip();
        if (needsClearance) {
            this.setInputText("");
        }
        this.setMinimumSize(this.getPreferredSize());
    }

    @Override
    public void setValidationResults(Iterable<ValidationResult> validationResults) {
    }

    private GenericInputImplementation getImplementation() {
        return this.inputImplementation;
    }

    public void adjustTooltip() {
    }

    @Override
    public void adjustBounds() {
        this.adjustTooltip();
    }

    @Override
    public JLabel getTitleLabel() {
        return this.getImplementation().createDefaultTitleLabel();
    }

    @Override
    public String getTitle() {
        return this.getImplementation().getTitle();
    }

    @Override
    public String getUnit() {
        return this.getImplementation().getUnitDenotation();
    }

    @Override
    public JLabel getUnitLabel() {
        return this.getImplementation().getUnitLabel();
    }

    @Override
    public Iterable<ValidationResult> validateInput() {
        return this.getImplementation().validateInput();
    }

    @Override
    public Value getBoundValue() {
        return this.getImplementation().getBoundValue();
    }

    @Override
    public String getText() {
        return this.getEditor().getText();
    }

    @Override
    public void addToPanel(JPanel panel, LayoutStrategy layoutStrategy) {
        this.getImplementation().addToPanel(panel, layoutStrategy);
    }

    @Override
    public JComponent getInputComponent() {
        return this;
    }

    @Override
    public void setInputText(String text) {
        this.getEditor().setText(text);
    }

    @Override
    public void setRealtimeSupervision(boolean enabled) {
        this.getImplementation().setRealtimeSupervision(enabled);
    }

    @Override
    public void addValueChangeSource() {
    }

    @Override
    public void removeValueChangeSource() {
    }

    @Override
    public String getActionDescription() {
        return null;
    }

    @Override
    public boolean canBeEdited() {
        return this.isEnabled();
    }

    @Override
    public void setEnabled(boolean state) {
        super.setEnabled(state);
        this.adjustTooltip();
    }

    public void setEditable(boolean state) {
        this.adjustTooltip();
    }

    @Override
    public void refreshFromValue() {
    }

    @Override
    public void showRequired(boolean isRequired) {
    }
}

