/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.inputs.time;

import com.schneide.base.input.inputs.generic.BoundAwareInput;
import com.schneide.base.input.inputs.generic.GenericInputImplementation;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.inputs.layout.LayoutStrategy;
import com.schneide.base.input.inputs.modes.TextualBasedInput;
import com.schneide.base.input.types.DateValue;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.validation.ValidationResult;
import com.schneide.base.text.Text;
import java.awt.Component;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.DateFormatter;
import org.jdesktop.swingx.JXDatePicker;

public class DateTimeChooserInput
extends JXDatePicker
implements Input,
TextualBasedInput,
BoundAwareInput {
    private static final long serialVersionUID = 7418897817918867227L;
    private static final String TIME_FORMAT = "HH:mm";
    private final JFormattedTextField timeField;
    private final GenericInputImplementation inputImplementation;
    private final JPanel inputComponent;

    public DateTimeChooserInput(DateValue value) {
        this.inputImplementation = new GenericInputImplementation(this, value, (JComponent)((Object)this));
        this.timeField = new JFormattedTextField(new DateFormatter(new SimpleDateFormat(TIME_FORMAT)));
        this.timeField.setToolTipText(TIME_FORMAT);
        this.timeField.setPreferredSize(new Dimension(50, this.timeField.getPreferredSize().height));
        this.timeField.setMinimumSize(this.getPreferredSize());
        this.timeField.setMaximumSize(this.getPreferredSize());
        boolean needsClearance = !value.hasValue() && value.canBeEmpty();
        this.setDate(value.getValue());
        this.setFormats(new String[]{"dd.MM.yyyy"});
        this.timeField.setValue(value.getValue());
        value.setSource(this);
        this.adjustTooltip();
        if (needsClearance) {
            this.setInputText("");
        }
        this.inputComponent = new JPanel();
        this.inputComponent.setLayout(new BoxLayout(this.inputComponent, 2));
        this.setMinimumSize(this.getPreferredSize());
        this.inputComponent.add((Component)((Object)this));
        this.inputComponent.add(this.timeField);
        this.timeField.setFocusLostBehavior(3);
    }

    @Override
    public void setValidationResults(Iterable<ValidationResult> validationResults) {
    }

    private GenericInputImplementation getImplementation() {
        return this.inputImplementation;
    }

    public void adjustTooltip() {
    }

    @Override
    public void adjustBounds() {
        this.adjustTooltip();
    }

    @Override
    public JLabel getTitleLabel() {
        return this.getImplementation().createDefaultTitleLabel();
    }

    @Override
    public String getTitle() {
        return this.getImplementation().getTitle();
    }

    @Override
    public String getUnit() {
        return this.getImplementation().getUnitDenotation();
    }

    @Override
    public JLabel getUnitLabel() {
        return this.getImplementation().getUnitLabel();
    }

    @Override
    public Iterable<ValidationResult> validateInput() {
        return this.getImplementation().validateInput();
    }

    @Override
    public Value getBoundValue() {
        return this.getImplementation().getBoundValue();
    }

    @Override
    public String getText() {
        String dateText = this.getDateText();
        String timeText = this.getTimeText();
        if (Text.isEmpty(dateText) && Text.isEmpty(timeText)) {
            return "";
        }
        return dateText + " " + timeText;
    }

    protected String getTimeText() {
        String result = this.timeField.getText();
        if (Text.isEmpty(result) && !this.getBoundValue().canBeEmpty()) {
            return "00:00";
        }
        return result;
    }

    protected String getDateText() {
        return this.getEditor().getText();
    }

    @Override
    public void addToPanel(JPanel panel, LayoutStrategy layoutStrategy) {
        this.getImplementation().addToPanel(panel, layoutStrategy);
    }

    @Override
    public JComponent getInputComponent() {
        return this.inputComponent;
    }

    @Override
    public void setInputText(String text) {
        DateValue boundValue = (DateValue)this.getImplementation().getBoundValue();
        if (null == boundValue) {
            return;
        }
        Date newDate = boundValue.getStoredValue();
        this.timeField.setValue(newDate);
        this.setDate(newDate);
    }

    protected void setInputTextFromGiven(String text) {
        this.getEditor().setText(text);
    }

    @Override
    public void setRealtimeSupervision(boolean enabled) {
        this.getImplementation().setRealtimeSupervision(enabled);
    }

    @Override
    public void addValueChangeSource() {
    }

    @Override
    public void removeValueChangeSource() {
    }

    @Override
    public String getActionDescription() {
        return null;
    }

    @Override
    public boolean canBeEdited() {
        return this.isEnabled();
    }

    @Override
    public void setEnabled(boolean state) {
        super.setEnabled(state);
        this.adjustTooltip();
    }

    public void setEditable(boolean state) {
        this.adjustTooltip();
    }

    @Override
    public void refreshFromValue() {
    }

    protected JFormattedTextField getTimeField() {
        return this.timeField;
    }

    @Override
    public void showRequired(boolean isRequired) {
    }
}

