/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.inputs.layout;

import com.schneide.base.input.inputs.layout.LayoutStrategy;
import com.schneide.base.layout.GridBagLayoutPanel;
import com.schneide.base.layout.StringGridBagLayout;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StringGridBagLayoutStrategy
implements LayoutStrategy {
    protected static final String WEST = "WEST";
    protected static final String CENTER = "CENTER";
    private final int x;
    private int y;

    public StringGridBagLayoutStrategy() {
        this(0, 0);
    }

    public StringGridBagLayoutStrategy(int initialX, int initialY) {
        this.x = initialX;
        this.y = initialY;
    }

    public GridBagLayoutPanel createCompatiblePanel() {
        return new GridBagLayoutPanel();
    }

    public StringGridBagLayout getCompatibleLayoutManager() {
        return new StringGridBagLayout();
    }

    @Override
    public void addTo(JPanel panel, JLabel titleLabel, JComponent inputComponent, JLabel unitLabel) {
        this.internalDefaultAddition(panel, titleLabel, inputComponent, unitLabel);
    }

    protected void internalDefaultAddition(JPanel panel, JComponent firstColumn, JComponent secondColumn, JComponent thirdColumn) {
        this.internalAddTo(panel, new JComponent[]{firstColumn, secondColumn, thirdColumn}, new String[]{this.buildTitleLabelConstraints(), this.buildInputComponentConstraints(), this.buildUnitLabelConstraints()});
    }

    protected void internalAddTo(JPanel panel, JComponent[] components, String[] constraints) {
        for (int i = 0; i < components.length; ++i) {
            panel.add((Component)components[i], constraints[i]);
        }
        ++this.y;
    }

    protected String buildTitleLabelConstraints() {
        return this.buildConstraintsForCurrentRow(this.getX(), this.getTitleLabelAnchor(), EFill.NONE, new String[0]);
    }

    protected String buildInputComponentConstraints() {
        return this.buildConstraintsForCurrentRow(this.getX() + 1, this.getInputComponentAnchor(), EFill.HORIZONTAL, new String[0]);
    }

    protected String buildUnitLabelConstraints() {
        return this.buildConstraintsForCurrentRow(this.getX() + 2, this.getUnitLabelAnchor(), EFill.NONE, new String[0]);
    }

    public int getX() {
        return this.x;
    }

    protected String getUnitLabelAnchor() {
        return WEST;
    }

    protected String getInputComponentAnchor() {
        return CENTER;
    }

    protected String getTitleLabelAnchor() {
        return this.getUnitLabelAnchor();
    }

    protected String buildConstraintsForCurrentRow(int xCoordinate, String anchor, EFill fill, String ... additionalConstraints) {
        return this.buildConstraints(xCoordinate, this.y, anchor, fill, additionalConstraints);
    }

    protected String buildConstraints(int xCoordinate, int yCoordinate, String anchor, EFill fill, String ... additionalConstraints) {
        DirectChunkBuffer buffer = new DirectChunkBuffer(", ", false);
        buffer.add("gridx=" + xCoordinate);
        buffer.add("gridy=" + yCoordinate);
        buffer.add("anchor=" + anchor);
        buffer.add(fill.getConstraint());
        buffer.add(this.getInsets());
        for (String additionalConstraint : additionalConstraints) {
            buffer.add(additionalConstraint);
        }
        return ((Object)buffer).toString();
    }

    protected String getInsets() {
        return "insets=[3,2,4,3]";
    }

    protected static enum EFill {
        NONE(""),
        HORIZONTAL("fill=HORIZONTAL"),
        VERTICAL("fill=VERTICAL"),
        BOTH("fill=BOTH");

        private final String constraint;

        private EFill(String constraint) {
            this.constraint = constraint;
        }

        public String getConstraint() {
            return this.constraint;
        }
    }
}

