/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.inputs.layout;

import com.schneide.base.input.inputs.layout.LayoutStrategy;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HorizontalBoxLayoutStrategy
implements LayoutStrategy {
    private final Dimension rigidArea;
    private boolean isFirstInput;

    public HorizontalBoxLayoutStrategy() {
        this(20);
    }

    public HorizontalBoxLayoutStrategy(int rigidArea) {
        this.rigidArea = new Dimension(rigidArea, 0);
        this.isFirstInput = true;
    }

    public Dimension getRigidArea() {
        return this.rigidArea;
    }

    @Override
    public void addTo(JPanel panel, JLabel titleLabel, JComponent inputComponent, JLabel unitLabel) {
        if (!this.isFirstInput) {
            panel.add(Box.createRigidArea(this.rigidArea));
            panel.add(Box.createHorizontalGlue());
        } else {
            this.isFirstInput = false;
        }
        if (titleLabel.getText().length() > 0) {
            panel.add(titleLabel);
            panel.add(Box.createRigidArea(this.rigidArea));
        }
        panel.add(inputComponent);
        if (unitLabel.getText().length() > 0) {
            panel.add(Box.createRigidArea(this.rigidArea));
            panel.add(unitLabel);
        }
    }
}

