/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.inputs;

import com.schneide.base.input.i18n.Localisation;
import com.schneide.base.input.inputs.generic.BoundAwareInput;
import com.schneide.base.input.inputs.generic.GenericInputImplementation;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.inputs.layout.LayoutStrategy;
import com.schneide.base.input.inputs.modes.TextualBasedInput;
import com.schneide.base.input.types.AssociationValue;
import com.schneide.base.input.types.DateValue;
import com.schneide.base.input.types.IntegerValue;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.validation.ValidationResult;
import com.schneide.base.system.Base;
import com.schneide.base.util.Parameter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class SpinnerInput
extends JSpinner
implements Input,
TextualBasedInput,
BoundAwareInput {
    private static final long serialVersionUID = -6196339337360816807L;
    private final GenericInputImplementation inputImplementation;

    public SpinnerInput(Value value) {
        this(value, value.getOriginalValue());
    }

    public SpinnerInput(IntegerValue value) {
        this(value, value.getOriginalValue());
    }

    public SpinnerInput(AssociationValue<?> value, Object content) {
        this(new SpinnerListModel(value.getKeys()), value, content);
    }

    public SpinnerInput(DateValue value) {
        this(new SpinnerDateModel(), value, null);
        ((SpinnerDateModel)this.getModel()).setCalendarField(5);
        DateFormat format = value.getFormatter();
        JSpinner.DateEditor editor = format instanceof SimpleDateFormat ? new JSpinner.DateEditor((JSpinner)this, ((SimpleDateFormat)format).toPattern()) : new JSpinner.DateEditor((JSpinner)this, "dd.MM.yyyy");
        this.setEditor(editor);
    }

    public SpinnerInput(Value value, Object content) {
        this(new SpinnerListModel(), value, content);
    }

    public SpinnerInput(IntegerValue value, Object content) {
        this(new SpinnerNumberModel(value.getValue(), value.getLowerBound(), value.getUpperBound(), 1), value, content);
    }

    private SpinnerInput(SpinnerModel model, Value value, Object content) {
        super(model);
        this.inputImplementation = new GenericInputImplementation(this, value, this);
        value.setSource(this);
        if (content != null) {
            this.setValue(content);
        }
        JFormattedTextField textfield = this.getEditorTextField();
        textfield.setHorizontalAlignment(10);
        this.setInputText(value.getTextualValue());
        this.adjustTooltip();
    }

    @Override
    public void setValidationResults(Iterable<ValidationResult> validationResults) {
    }

    private GenericInputImplementation getImplementation() {
        return this.inputImplementation;
    }

    public void adjustTooltip() {
        if (this.getImplementation() != null) {
            JFormattedTextField textfield = this.getEditorTextField();
            textfield.setToolTipText(this.getImplementation().getDescription());
        }
    }

    @Override
    public void adjustBounds() {
        this.adjustTooltip();
        if (this.getModel() instanceof SpinnerNumberModel) {
            this.adjustBoundsForIntegerValue((SpinnerNumberModel)this.getModel());
        }
    }

    private void adjustBoundsForIntegerValue(SpinnerNumberModel numberModel) {
        if (!(this.getImplementation().getBoundValue() instanceof IntegerValue)) {
            return;
        }
        IntegerValue value = (IntegerValue)this.getImplementation().getBoundValue();
        numberModel.setMinimum(Integer.valueOf(value.getLowerBound()));
        numberModel.setMaximum(Integer.valueOf(value.getUpperBound()));
    }

    private JFormattedTextField getEditorTextField() {
        JFormattedTextField result = null;
        try {
            JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.getEditor();
            result = editor.getTextField();
        }
        catch (ClassCastException e) {
            Base.getLogger(this).warn("Wrong type accessed.", e);
        }
        return result;
    }

    @Override
    public JLabel getTitleLabel() {
        return this.getImplementation().createDefaultTitleLabel();
    }

    @Override
    public String getTitle() {
        return this.getImplementation().getTitle();
    }

    @Override
    public String getUnit() {
        return this.getImplementation().getUnitDenotation();
    }

    @Override
    public JLabel getUnitLabel() {
        return this.getImplementation().getUnitLabel();
    }

    @Override
    public Iterable<ValidationResult> validateInput() {
        return this.getImplementation().validateInput();
    }

    @Override
    public Value getBoundValue() {
        return this.getImplementation().getBoundValue();
    }

    @Override
    public String getText() {
        Value value = this.getImplementation().getBoundValue();
        if (value instanceof DateValue) {
            return ((DateValue)value).getFormatter().format(this.getValue());
        }
        return this.getValue().toString();
    }

    @Override
    public void addToPanel(JPanel panel, LayoutStrategy layoutStrategy) {
        this.getImplementation().addToPanel(panel, layoutStrategy);
    }

    @Override
    public JComponent getInputComponent() {
        return this;
    }

    @Override
    public void setInputText(String text) {
        if (this.getImplementation().getBoundValue() instanceof IntegerValue) {
            try {
                this.setValue(Integer.parseInt(text));
            }
            catch (NumberFormatException e) {
                Parameter.isPresent(e);
                this.setValue(0);
            }
        } else if (this.getImplementation().getBoundValue() instanceof DateValue) {
            DateValue dateValue = (DateValue)this.getBoundValue();
            if (dateValue.hasFormatter()) {
                try {
                    this.setValue(dateValue.getFormatter().parse(text));
                }
                catch (ParseException e) {
                    Base.getLogger(this).error("Parsefehler.", e);
                }
            } else {
                this.setValue(text);
            }
        }
    }

    @Override
    public void setRealtimeSupervision(boolean enabled) {
        this.getImplementation().setRealtimeSupervision(enabled);
    }

    @Override
    public void addValueChangeSource() {
        this.addChangeListener(this.getImplementation());
    }

    @Override
    public void removeValueChangeSource() {
        this.removeChangeListener(this.getImplementation());
    }

    @Override
    public String getActionDescription() {
        if (this.isEnabled()) {
            StringBuffer result = new StringBuffer();
            if (this.canEditInTextfield()) {
                result.append(Localisation.getLocalizedString("input.spinner.action.description.editable"));
                result.append("/");
            }
            result.append(Localisation.getLocalizedString("input.spinner.action.description"));
            return result.toString();
        }
        return Localisation.getLocalizedString("input.spinner.action.description.disabled");
    }

    private boolean canEditInTextfield() {
        JFormattedTextField textfield = this.getEditorTextField();
        if (textfield != null) {
            return textfield.isEditable();
        }
        return false;
    }

    @Override
    public boolean canBeEdited() {
        return this.isEnabled();
    }

    @Override
    public void setEnabled(boolean state) {
        super.setEnabled(state);
        this.adjustTooltip();
    }

    public void setEditable(boolean state) {
        JFormattedTextField textfield = this.getEditorTextField();
        if (textfield != null) {
            textfield.setEditable(state);
        }
        this.adjustTooltip();
    }

    @Override
    protected JComponent createEditor(SpinnerModel model) {
        if (model instanceof SpinnerNumberModel) {
            return new JSpinner.NumberEditor((JSpinner)this, "0");
        }
        return super.createEditor(model);
    }

    @Override
    public void refreshFromValue() {
    }

    @Override
    public void showRequired(boolean isRequired) {
        this.inputImplementation.showRequired(isRequired, this.backgroundColorTarget());
    }

    private Supplier<JComponent> backgroundColorTarget() {
        if (this.getEditor() instanceof JSpinner.NumberEditor) {
            return () -> ((JSpinner.NumberEditor)this.getEditor()).getTextField();
        }
        return () -> this.getInputComponent();
    }
}

