/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.inputs;

import com.schneide.base.input.i18n.Localisation;
import com.schneide.base.input.inputs.generic.ColumnAwareInput;
import com.schneide.base.input.inputs.generic.GenericInputImplementation;
import com.schneide.base.input.inputs.generic.InputColumnHandler;
import com.schneide.base.input.inputs.layout.LayoutStrategy;
import com.schneide.base.input.inputs.modes.TextualBasedInput;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.validation.ValidationResult;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class PasswordInput
extends JPasswordField
implements ColumnAwareInput,
TextualBasedInput {
    private static final long serialVersionUID = -7829524933748151994L;
    private final GenericInputImplementation inputImplementation;

    public PasswordInput(Value value) {
        this(value, InputColumnHandler.calculateColumnsFor(value));
    }

    public PasswordInput(Value value, int columns) {
        this.setColumns(columns);
        this.inputImplementation = new GenericInputImplementation(this, value, this);
        value.setSource(this);
        if (value.getOriginalValue() != null) {
            this.setInputText(value.getOriginalValue().toString());
        }
        this.adjustTooltip();
    }

    @Override
    public void setValidationResults(Iterable<ValidationResult> validationResults) {
    }

    public void adjustTooltip() {
        if (this.getImplementation() != null) {
            this.setToolTipText(this.getImplementation().getDescription());
        }
    }

    @Override
    public JLabel getTitleLabel() {
        return this.getImplementation().createDefaultTitleLabel();
    }

    @Override
    public String getTitle() {
        return this.getImplementation().getTitle();
    }

    @Override
    public String getUnit() {
        return this.getImplementation().getUnitDenotation();
    }

    private GenericInputImplementation getImplementation() {
        return this.inputImplementation;
    }

    @Override
    public JLabel getUnitLabel() {
        return this.getImplementation().getUnitLabel();
    }

    @Override
    public Iterable<ValidationResult> validateInput() {
        return this.getImplementation().validateInput();
    }

    @Override
    public Value getBoundValue() {
        return this.getImplementation().getBoundValue();
    }

    @Override
    public void addToPanel(JPanel panel, LayoutStrategy layoutStrategy) {
        this.getImplementation().addToPanel(panel, layoutStrategy);
    }

    @Override
    public JComponent getInputComponent() {
        return this;
    }

    @Override
    public void setInputText(String text) {
        int caretPosition = this.getCaretPosition();
        super.setText(text);
        this.setCaretPosition(caretPosition);
    }

    @Override
    public void setRealtimeSupervision(boolean enabled) {
        this.getImplementation().setRealtimeSupervision(enabled);
    }

    @Override
    public void addValueChangeSource() {
        this.getDocument().addDocumentListener(this.getImplementation());
    }

    @Override
    public void removeValueChangeSource() {
        this.getDocument().removeDocumentListener(this.getImplementation());
    }

    @Override
    public String getActionDescription() {
        return Localisation.getLocalizedString("input.password.action.description");
    }

    @Override
    public boolean canBeEdited() {
        return this.isEditable() && this.isEnabled();
    }

    @Override
    public void setEnabled(boolean state) {
        super.setEnabled(state);
        this.adjustTooltip();
    }

    @Override
    public void setEditable(boolean state) {
        super.setEditable(state);
        this.adjustTooltip();
    }

    @Override
    public void refreshFromValue() {
    }

    @Override
    public void showRequired(boolean isRequired) {
        this.inputImplementation.showRequired(isRequired);
    }
}

