/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.inputs;

import com.schneide.base.gui.swing.EDT;
import com.schneide.base.input.i18n.Localisation;
import com.schneide.base.input.inputs.generic.GenericInputImplementation;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.inputs.layout.LayoutStrategy;
import com.schneide.base.input.inputs.modes.TextualBasedInput;
import com.schneide.base.input.types.AssociationValue;
import com.schneide.base.input.types.BooleanValue;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.validation.ValidationResult;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class ComboboxInput
extends JComboBox<String>
implements Input,
TextualBasedInput {
    private static final long serialVersionUID = -9060600539582677181L;
    private final GenericInputImplementation inputImplementation;

    public ComboboxInput(Value value) {
        this(value, null);
    }

    public ComboboxInput(AssociationValue<?> value) {
        this(value, value.getKeys(), value.getKeyOfValue());
        this.setEditable(!value.isStrict());
    }

    public ComboboxInput(BooleanValue value) {
        this(value, value.getMainStrings(), value.getTextualValue());
    }

    public ComboboxInput(Value value, Object[] choices) {
        this(value, choices, value.getOriginalValue());
    }

    private static Object[] givenChoices(Value value, Object[] predefined) {
        if (null != predefined) {
            return predefined;
        }
        if (value instanceof AssociationValue) {
            return ((AssociationValue)value).getKeys();
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).getMainStrings();
        }
        return null;
    }

    public ComboboxInput(Value value, Object[] choices, Object content) {
        this.inputImplementation = new GenericInputImplementation(this, value, this);
        value.setSource(this);
        Object[] givenChoices = ComboboxInput.givenChoices(value, choices);
        if (givenChoices != null) {
            for (Object element : givenChoices) {
                this.addItem(String.valueOf(element));
            }
        }
        this.adjustTooltip();
        if (content != null) {
            this.setSelectedItem(content);
        } else {
            this.preselectFor(givenChoices);
        }
    }

    protected void preselectFor(Object[] choices) {
        if (this.isSingleChoice(choices)) {
            this.preselectIfSingleOption(choices);
            return;
        }
        this.setSelectedItem(null);
    }

    protected boolean isSingleChoice(Object[] choices) {
        return 1 == choices.length;
    }

    protected void preselectIfSingleOption(Object[] choices) {
        if (this.isSingleChoice(choices)) {
            this.setSelectedItem(choices[0]);
        }
    }

    @Override
    public void setValidationResults(Iterable<ValidationResult> validationResults) {
    }

    @Override
    public void refreshFromValue() {
        EDT.perform(() -> {
            if (this.inputImplementation.getBoundValue() instanceof AssociationValue) {
                Object[] keys;
                AssociationValue association = (AssociationValue)this.inputImplementation.getBoundValue();
                this.removeAllItems();
                this.setSelectedItem(null);
                for (String string : keys = association.getKeys()) {
                    this.addItem(string);
                }
                this.preselectIfSingleOption(keys);
            }
        });
    }

    public void adjustTooltip() {
        if (this.getImplementation() != null) {
            this.setToolTipText(this.getImplementation().getDescription());
        }
    }

    @Override
    public JLabel getTitleLabel() {
        return this.getImplementation().createDefaultTitleLabel();
    }

    @Override
    public String getTitle() {
        return this.getImplementation().getTitle();
    }

    private GenericInputImplementation getImplementation() {
        return this.inputImplementation;
    }

    @Override
    public String getUnit() {
        return this.getImplementation().getUnitDenotation();
    }

    @Override
    public JLabel getUnitLabel() {
        return this.getImplementation().getUnitLabel();
    }

    @Override
    public Iterable<ValidationResult> validateInput() {
        return this.getImplementation().validateInput();
    }

    @Override
    public Value getBoundValue() {
        return this.getImplementation().getBoundValue();
    }

    @Override
    public void addToPanel(JPanel panel, LayoutStrategy layoutStrategy) {
        this.getImplementation().addToPanel(panel, layoutStrategy);
    }

    @Override
    public JComponent getInputComponent() {
        return this;
    }

    @Override
    public void setInputText(String text) {
        Component editorComponent = this.getEditor().getEditorComponent();
        boolean resetEditability = false;
        if (!super.isEditable()) {
            super.setEditable(true);
            resetEditability = true;
        }
        this.setSelectedItem(text);
        if (editorComponent instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)editorComponent;
            textComponent.setCaretPosition(0);
        }
        if (resetEditability) {
            super.setEditable(false);
        }
    }

    @Override
    public void setRealtimeSupervision(boolean enabled) {
        this.getImplementation().setRealtimeSupervision(enabled);
    }

    @Override
    public void addValueChangeSource() {
        this.addActionListener(this.getImplementation());
    }

    @Override
    public void removeValueChangeSource() {
        this.removeActionListener(this.getImplementation());
    }

    @Override
    public String getText() {
        if (this.getSelectedItem() != null) {
            return this.getSelectedItem().toString();
        }
        return null;
    }

    @Override
    public void showRequired(boolean isRequired) {
    }

    @Override
    public String getActionDescription() {
        StringBuffer result = new StringBuffer();
        result.append(Localisation.getLocalizedString("input.combobox.action.description"));
        if (this.isEditable()) {
            result.append("/");
            result.append(Localisation.getLocalizedString("input.combobox.action.description.editable"));
        }
        return result.toString();
    }

    @Override
    public boolean canBeEdited() {
        return this.isEnabled();
    }

    @Override
    public void setEnabled(boolean state) {
        super.setEnabled(state);
        this.adjustTooltip();
    }

    @Override
    public void setEditable(boolean state) {
        super.setEditable(state);
        this.adjustTooltip();
    }
}

