/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.helper;

import com.schneide.base.input.helper.InputCreator;
import com.schneide.base.input.helper.LayoutHelper;
import com.schneide.base.input.helper.LayoutSpecification;
import com.schneide.base.input.inputs.InputFactory;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.types.generic.Value;
import java.util.ArrayList;
import javax.swing.JPanel;

public class BuildLayoutFor {
    private final Iterable<Value> values;
    private InputCreator inputFactory;

    public BuildLayoutFor(Iterable<Value> values) {
        this.values = values;
        this.inputFactory = value -> value.createNaturalInput(new InputFactory.DesktopInputFactory());
    }

    public static BuildLayoutFor values(Iterable<Value> values) {
        return new BuildLayoutFor(values);
    }

    public BuildLayoutFor withInputsFrom(InputCreator newInputFactory) {
        this.inputFactory = newInputFactory;
        return this;
    }

    public JPanel using(LayoutSpecification strategy) {
        ArrayList<Input> inputs = new ArrayList<Input>();
        for (Value value : this.values) {
            inputs.add(this.inputFactory.createFor(value));
        }
        return LayoutHelper.buildPanelFor(strategy, inputs);
    }
}

