/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.datatypes;

import com.schneide.base.input.i18n.Localisation;

public class IntegerValueRange {
    public static final int LOWEST_BOUND = Integer.MIN_VALUE;
    public static final int UPMOST_BOUND = Integer.MAX_VALUE;
    public static final int DEFAULT_LOWER_BOUND = Integer.MIN_VALUE;
    public static final int DEFAULT_UPPER_BOUND = Integer.MAX_VALUE;
    private final int lowerBound;
    private final int upperBound;

    public static IntegerValueRange fullBounds(int low, int high) {
        return new IntegerValueRange(low, high);
    }

    public static IntegerValueRange lowBound(int low) {
        return new IntegerValueRange(low);
    }

    public static IntegerValueRange highBound(int high) {
        return new IntegerValueRange(Integer.MIN_VALUE, high);
    }

    public static IntegerValueRange zeroToBound(int high) {
        return new IntegerValueRange(0, high);
    }

    public IntegerValueRange() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerValueRange(int lowerBound) {
        this(lowerBound, Integer.MAX_VALUE);
    }

    public IntegerValueRange(int lowerBound, int upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public boolean isValueInRange(int value) {
        return value >= this.getLowerBound() && value <= this.getUpperBound();
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public boolean hasLowerRestriction() {
        return this.getLowerBound() > Integer.MIN_VALUE;
    }

    public boolean hasUpperRestriction() {
        return this.getUpperBound() < Integer.MAX_VALUE;
    }

    public String toString() {
        return "[" + this.getLowerBound() + "; " + this.getUpperBound() + "]";
    }

    public String getIntuitiveDescription() {
        StringBuffer result = new StringBuffer();
        if (this.hasLowerRestriction()) {
            if (this.hasUpperRestriction()) {
                this.stuffBufferWith(result, "valuerange.integer.from");
            } else {
                this.stuffBufferWith(result, "valuerange.integer.ex");
            }
            result.append(this.getLowerBound());
        }
        if (this.hasUpperRestriction()) {
            this.stuffBufferWith(result, "valuerange.integer.to");
            result.append(this.getUpperBound());
        }
        return result.toString();
    }

    public String getFullDescription() {
        StringBuffer result = new StringBuffer();
        this.stuffBufferWith(result, "valuerange.integer.from");
        result.append(this.getLowerBound());
        this.stuffBufferWith(result, "valuerange.integer.to");
        result.append(this.getUpperBound());
        return result.toString();
    }

    private void stuffBufferWith(StringBuffer result, String localizationKey) {
        result.append(" ");
        result.append(Localisation.getLocalizedString(localizationKey));
        result.append(" ");
    }
}

