/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.i18n.missing;

import com.schneide.base.i18n.missing.MissingI18NEntryHandler;
import com.schneide.base.io.encoding.Encoding;
import com.schneide.base.io.stream.provider.OutputStreamProvider;
import com.schneide.base.io.tools.IOCloser;
import com.schneide.base.logging.LoggedObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PersistedMissingI18NEntryHandler
extends LoggedObject
implements MissingI18NEntryHandler,
Runnable {
    private static final DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd.HHmmss");
    private final DateFormat format;
    private final PrintWriter target;

    public PersistedMissingI18NEntryHandler(File outputFile, boolean isDateActivated) throws IOException {
        this(outputFile, PersistedMissingI18NEntryHandler.createDefaultFormat(isDateActivated));
    }

    public PersistedMissingI18NEntryHandler(OutputStream output, boolean isDateActivated) throws IOException {
        this(() -> output, PersistedMissingI18NEntryHandler.createDefaultFormat(isDateActivated));
    }

    public PersistedMissingI18NEntryHandler(Writer writer, boolean isDateActivated) {
        this(writer, PersistedMissingI18NEntryHandler.createDefaultFormat(isDateActivated));
    }

    private static DateFormat createDefaultFormat(boolean isActivated) {
        if (isActivated) {
            return DEFAULT_DATE_FORMAT;
        }
        return null;
    }

    public PersistedMissingI18NEntryHandler(File outputFile, DateFormat format) throws IOException {
        this(() -> new FileOutputStream(outputFile, true), format);
    }

    public PersistedMissingI18NEntryHandler(OutputStreamProvider output, DateFormat format) throws IOException {
        this((Writer)new OutputStreamWriter(output.stream(), Encoding.isoLatin1()), format);
    }

    public PersistedMissingI18NEntryHandler(Writer writer, DateFormat format) {
        this.format = format;
        this.target = new PrintWriter(writer);
        Runtime.getRuntime().addShutdownHook(new Thread(this));
    }

    private PrintWriter getTarget() {
        return this.target;
    }

    public DateFormat getDateFormat() {
        return this.format;
    }

    public boolean hasDateFormat() {
        return this.getDateFormat() != null;
    }

    @Override
    public void run() {
        IOCloser.close(this.getTarget());
    }

    @Override
    public String informMissingEntry(String missingKey) {
        if (this.hasDateFormat()) {
            this.getTarget().print(this.getDateFormat().format(new Date()));
            this.getTarget().print(" ");
        }
        this.getTarget().println(missingKey);
        this.getTarget().flush();
        return missingKey;
    }
}

