/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.i18n.implementation;

import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.TextualContent;

public class ContextedTextualContent
implements TextualContent {
    private final I18NKey contextKey;
    private final TextualContent baseContent;

    public ContextedTextualContent(String contextKey, TextualContent baseContent) {
        this(new I18NKey(contextKey), baseContent);
    }

    public ContextedTextualContent(I18NKey contextKey, TextualContent baseContent) {
        this.contextKey = contextKey;
        this.baseContent = baseContent;
    }

    @Override
    public void clearCache() {
        this.baseContent.clearCache();
    }

    private String getFullContextKey(String key) {
        return this.contextKey.withKeyPart(key).getKey();
    }

    @Override
    public String getParametrizedText(String key, Object ... parameters) {
        return this.baseContent.getParametrizedText(this.getFullContextKey(key), parameters);
    }

    @Override
    public String getText(String key) {
        return this.baseContent.getText(this.getFullContextKey(key));
    }

    @Override
    public boolean hasTextFor(String key) {
        return this.baseContent.hasTextFor(this.getFullContextKey(key));
    }

    @Override
    public void reload() {
        this.baseContent.reload();
    }
}

