/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.i18n;

import com.schneide.base.datatypes.collections.iterable.EmptyIterable;
import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.system.Base;
import com.schneide.base.text.Text;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import com.schneide.base.util.EqualsBuilder;
import java.io.Serializable;
import java.util.ArrayList;

public class I18NKey
implements I18NResolvable,
EqualsBuilder.EqualComparable,
Serializable {
    private static final long serialVersionUID = 8402921459853781509L;
    public static final I18NKey NOT_GIVEN = new I18NKey();
    private final String key;

    public I18NKey() {
        this("");
    }

    public I18NKey(I18NKey base, String part) {
        this(I18NKey.appendKeyParts(base.getKey(), part));
    }

    @Override
    public boolean isI18Ned() {
        return true;
    }

    public static I18NKey buildFromContext(I18NKey context, String part) {
        return new I18NKey(context, part);
    }

    public static I18NKey buildFromParts(String ... parts) {
        return new I18NKey(I18NKey.appendKeyParts(parts));
    }

    public I18NKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("An I18N-Key must not be null.");
        }
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public I18NKey getI18NKey() {
        return this;
    }

    @Override
    public Iterable<Object> getParameters() {
        return new EmptyIterable<Object>();
    }

    @Override
    public I18NKey withKeyPart(String keyPart) {
        return new I18NKey(I18NKey.appendKeyParts(this.getKey(), keyPart));
    }

    @Override
    public String resolvedText() {
        return Base.getTextContent().getText(this.getKey());
    }

    @Override
    public boolean isResolvableWithoutFallback() {
        return Base.getTextContent().hasTextFor(this.getKey());
    }

    public String getResolvedText(Object ... parameters) {
        return Base.getTextContent().getParametrizedText(this.getKey(), this.getExpandedParameters(parameters));
    }

    protected Object[] getExpandedParameters(Object ... parameters) {
        if (!this.containsExpandables(parameters)) {
            return parameters;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object each : parameters) {
            if (this.isExpandable(each)) {
                result.add(((I18NResolvable)each).resolvedText());
                continue;
            }
            result.add(each);
        }
        return result.toArray(new Object[result.size()]);
    }

    private boolean isExpandable(Object parameter) {
        return parameter instanceof I18NResolvable;
    }

    private boolean containsExpandables(Object ... parameters) {
        for (Object object : parameters) {
            if (!this.isExpandable(object)) continue;
            return true;
        }
        return false;
    }

    public static String appendKeyParts(String ... parts) {
        DirectChunkBuffer buffer = new DirectChunkBuffer(".");
        for (String string : parts) {
            if (!Text.hasContent(string)) continue;
            buffer.append(string);
        }
        return ((Object)buffer).toString();
    }

    public Iterable<Object> getValuesToCompare() {
        return new SingleElementIterable<Object>(this.key);
    }

    public int hashCode() {
        return EqualsBuilder.hashCodeFor(this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.isEqual(this, obj);
    }

    public String toString() {
        return this.resolvedText();
    }
}

