/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.util;

import com.schneide.base.gui.FilenameAdjuster;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.logging.LoggedObject;
import java.awt.Component;
import java.io.File;
import java.util.Optional;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class SingleFileSelector {
    private final FileFilter filter;
    private String name;

    public SingleFileSelector(FileFilter filter) {
        this("SingleFileSelector", filter);
    }

    public SingleFileSelector(String name, FileFilter filter) {
        this.name = name;
        this.filter = filter;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SelectionResult selectFileAt(WindowStack windowStack, File startDirectory) {
        return this.selectFileAt(windowStack.getActiveWindow(), startDirectory);
    }

    public SelectionResult selectFileAt(Component parent, File startDirectory) {
        return EDT.query(() -> {
            FileChooserVisualizer visualizer = new FileChooserVisualizer();
            visualizer.showChooser(parent, startDirectory);
            return visualizer.getSelectedResult();
        });
    }

    protected FileFilter filter() {
        return this.filter;
    }

    protected String name() {
        return this.name;
    }

    public static interface SelectionResult {
        public boolean hasSelectedFile();

        public File getSelectedFile();

        public File getAdjustedSelectedFile();

        public Optional<File> asOptional();
    }

    protected class FileChooserVisualizer
    extends LoggedObject {
        private SelectionResult selectedResult;

        public FileChooserVisualizer() {
            this.selectedResult = new GenericSelectionResult(null);
        }

        public void showChooser(Component parent, File startDirectory) {
            Runnable chooserRunnable = this.createChooserRunnableFor(parent, startDirectory);
            EDT.performBlocking(chooserRunnable);
        }

        protected Runnable createChooserRunnableFor(Component parent, File startDirectory) {
            return () -> {
                JFileChooser chooser = new JFileChooser(startDirectory);
                chooser.setName(SingleFileSelector.this.name());
                chooser.setFileSelectionMode(0);
                chooser.setMultiSelectionEnabled(false);
                chooser.setFileFilter(SingleFileSelector.this.filter());
                int answer = chooser.showOpenDialog(parent);
                this.selectedResult = 0 == answer ? new GenericSelectionResult(chooser.getSelectedFile()) : new GenericSelectionResult(null);
            };
        }

        public SelectionResult getSelectedResult() {
            return this.selectedResult;
        }
    }

    private class GenericSelectionResult
    implements SelectionResult {
        private final File selectedFile;

        public GenericSelectionResult(File selectedFile) {
            this.selectedFile = selectedFile;
        }

        @Override
        public File getSelectedFile() {
            return this.selectedFile;
        }

        @Override
        public File getAdjustedSelectedFile() {
            if (!(SingleFileSelector.this.filter() instanceof FilenameAdjuster)) {
                return this.getSelectedFile();
            }
            FilenameAdjuster adjuster = (FilenameAdjuster)((Object)SingleFileSelector.this.filter());
            return new File(adjuster.adjust(this.getSelectedFile().getPath()));
        }

        @Override
        public boolean hasSelectedFile() {
            return null != this.getSelectedFile();
        }

        @Override
        public Optional<File> asOptional() {
            if (this.hasSelectedFile()) {
                return Optional.of(this.getAdjustedSelectedFile());
            }
            return Optional.empty();
        }
    }
}

