/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.swing;

import com.schneide.base.gui.swing.EDTQuery;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.threading.executor.DoInBackground;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;

public final class EDT
extends LoggedObject {
    private EDT() {
    }

    public static void always() {
        EDT.checkIsOnEDT();
    }

    public static void whatever() {
    }

    public static void only() {
        EDT.checkIsOnEDT();
    }

    public static void never() {
        if (EDT.isThis()) {
            EDT.reportEDTUsageFailure(" was called on EDT, though it shouldn't!");
        }
    }

    protected static void checkIsOnEDT() {
        if (!EDT.isThis()) {
            EDT.reportEDTUsageFailure(" was not called on EDT, though it should have been!");
        }
    }

    protected static void reportEDTUsageFailure(String message) {
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        System.err.println(EDT.describe(ste[4]) + message + " (Came from " + EDT.describe(ste[5]) + ")");
    }

    private static String describe(StackTraceElement stackElement) {
        return stackElement.getClassName() + "->" + stackElement.getMethodName();
    }

    public static boolean isThis() {
        return EventQueue.isDispatchThread();
    }

    public static void later(Runnable actionOnEDT) {
        EventQueue.invokeLater(actionOnEDT);
    }

    public static void runNormally(Runnable actionNotOnEDT) {
        DoInBackground.now("non-EDT action", actionNotOnEDT);
    }

    public static void perform(Runnable actionOnEDT) {
        if (!EDT.isThis()) {
            EDT.later(actionOnEDT);
            return;
        }
        actionOnEDT.run();
    }

    public static void performBlocking(Runnable actionOnEDT) {
        if (!EDT.isThis()) {
            try {
                EventQueue.invokeAndWait(actionOnEDT);
            }
            catch (InterruptedException e) {
                EDT.getStaticLogger().warn("Could not wait on EDT action, interrupted.", e);
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException e) {
                EDT.getStaticLogger().warn("Exception while performing blocking EDT action.");
                e.printStackTrace();
            }
            return;
        }
        actionOnEDT.run();
    }

    public static void waitUntilAllPendingEventsAreProcessed() {
        EDT.performBlocking(() -> {});
    }

    public static <T> T query(EDTQuery<T> query) {
        EDTQueryResult<T> result = new EDTQueryResult<T>(query);
        EDT.performBlocking(result);
        return result.getResult();
    }

    private static class EDTQueryResult<TYPE>
    implements Runnable {
        private TYPE result;
        private final EDTQuery<TYPE> query;

        public EDTQueryResult(EDTQuery<TYPE> query) {
            this.query = query;
            this.result = null;
        }

        @Override
        public void run() {
            this.result = this.query.perform();
        }

        public TYPE getResult() {
            return this.result;
        }
    }
}

