/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.support;

import com.schneide.base.gui.support.WidgetCollector;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.text.Text;
import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WidgetNamer
extends LoggedObject {
    public void nameAllIn(Container container) {
        EDT.only();
        WidgetCollector collector = new WidgetCollector(new WidgetCollector.WidgetCriteria[0]);
        Iterable<Component> widgets = collector.collectFrom(container);
        for (Component widget : widgets) {
            this.name(widget);
        }
    }

    protected void name(Component widget) {
        if (!Text.isEmpty(widget.getName())) {
            return;
        }
        this.nameByText(widget);
    }

    protected void nameByText(Component widget) {
        String name = this.retrieveTextFrom(widget);
        this.getLogger().debug("Setting name " + name + " for widget " + String.valueOf(widget));
        widget.setName(name);
    }

    protected String retrieveTextFrom(Component widget) {
        try {
            Method getTextMethod = widget.getClass().getMethod("getText", new Class[0]);
            Object text = getTextMethod.invoke((Object)widget, new Object[0]);
            return String.valueOf(text);
        }
        catch (SecurityException e) {
            this.getLogger().warn("Not allowed to call getText() reflectively on widget " + String.valueOf(widget), e);
        }
        catch (NoSuchMethodException e) {
            this.getLogger().debug("Cannot set name for widget " + String.valueOf(widget) + ": no getText() method");
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("", e);
        }
        catch (IllegalAccessException e) {
            this.getLogger().warn("", e);
        }
        catch (InvocationTargetException e) {
            this.getLogger().warn("", e);
        }
        return null;
    }
}

