/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.image;

import com.schneide.base.random.RandomnessGenerator;
import com.schneide.base.threading.ThreadMutex;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class RandomImagePainter {
    private final RandomnessGenerator random = new RandomnessGenerator();
    private final BufferedImage currentImage;
    private final ThreadMutex imageLock = new ThreadMutex();

    public RandomImagePainter() {
        this.currentImage = this.createInitialImage(640, 480);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getCurrentImage() {
        ThreadMutex threadMutex = this.imageLock;
        synchronized (threadMutex) {
            return this.currentImage;
        }
    }

    private BufferedImage createInitialImage(int width, int height) {
        BufferedImage result = new BufferedImage(width, height, 1);
        this.drawRandomColorRectangleInto(result.getGraphics(), 0, 0, result.getWidth(), result.getHeight());
        return result;
    }

    private void drawRandomRectangleInto(Graphics graphics, Dimension maximalSize) {
        this.drawRandomColorRectangleInto(graphics, this.random.getRandomInteger(maximalSize.width), this.random.getRandomInteger(maximalSize.height), this.random.getRandomInteger(maximalSize.width), this.random.getRandomInteger(maximalSize.height));
    }

    private void drawRandomColorRectangleInto(Graphics graphics, int x, int y, int width, int height) {
        graphics.setColor(this.getRandomColor());
        graphics.fillRect(x, y, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeImage() {
        ThreadMutex threadMutex = this.imageLock;
        synchronized (threadMutex) {
            this.drawRandomRectangleInto(this.currentImage.getGraphics(), new Dimension(this.currentImage.getWidth(), this.currentImage.getHeight()));
        }
    }

    private Color getRandomColor() {
        return new Color(this.random.getRandomInteger(256), this.random.getRandomInteger(256), this.random.getRandomInteger(256));
    }
}

