/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.icon;

import com.schneide.base.gui.icon.CachedIcon;
import com.schneide.base.gui.icon.IconProvider;
import com.schneide.base.gui.icon.NoIcon;
import com.schneide.base.gui.image.ImageProducer;
import com.schneide.base.gui.swing.EDT;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.function.Function;
import javax.swing.ImageIcon;

public final class Overlay
implements IconProvider {
    private static final Function<Dimension, Point> topRightCorner = size -> new Point(0, 0);
    private final IconProvider original;
    private IconProvider overlay;
    private Function<Dimension, Point> location;

    private Overlay(IconProvider original) {
        this.original = original;
        this.overlay = new NoIcon();
        this.location = topRightCorner;
    }

    public static Overlay icon(IconProvider original) {
        return new Overlay(original);
    }

    public Overlay with(IconProvider newOverlay) {
        this.overlay = newOverlay;
        return this;
    }

    public Overlay at(Function<Dimension, Point> position) {
        this.location = position;
        return this;
    }

    public Overlay atTopRightCorner() {
        return this.at(topRightCorner);
    }

    public Overlay atBottomLeftCorner() {
        return this.at(size -> {
            EDT.always();
            ImageIcon currentOverlay = this.overlay.icon();
            return new Point(size.width - currentOverlay.getIconWidth(), size.height - currentOverlay.getIconHeight());
        });
    }

    public IconProvider withCache() {
        return new CachedIcon(this);
    }

    @Override
    public ImageIcon icon() {
        ImageIcon background = this.original.icon();
        ImageIcon foreground = this.overlay.icon();
        return EDT.query(() -> {
            EDT.only();
            BufferedImage overlayed = new ImageProducer().createBufferedImageFrom(background.getImage());
            Graphics g = overlayed.getGraphics();
            Point position = this.locationInside(overlayed);
            g.drawImage(foreground.getImage(), position.x, position.y, null);
            g.dispose();
            return new ImageIcon(overlayed);
        });
    }

    private Point locationInside(BufferedImage overlayed) {
        return this.location.apply(new Dimension(overlayed.getWidth(), overlayed.getWidth()));
    }
}

