/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.icon;

import com.schneide.base.gui.swing.EDT;
import com.schneide.base.io.file.FileLocator;
import com.schneide.base.system.Base;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;

public final class IconLoader {
    private IconLoader() {
    }

    public static ImageIcon loadIcon(File file) {
        EDT.only();
        if (null == file) {
            return IconLoader.none();
        }
        try {
            URL iconURL = file.toURI().toURL();
            Base.getLogger(IconLoader.class).debug("Loading icon at " + String.valueOf(iconURL));
            return new ImageIcon(iconURL);
        }
        catch (MalformedURLException e) {
            Base.getLogger(IconLoader.class).error("Cannot load icon from " + String.valueOf(file), e);
            return IconLoader.none();
        }
    }

    public static ImageIcon loadWithoutAnyChecksDirectlyFrom(File file) {
        return new ImageIcon(file.getAbsolutePath());
    }

    public static ImageIcon loadIcon(String path) {
        EDT.only();
        if (null == path) {
            return IconLoader.none();
        }
        return IconLoader.loadIcon(FileLocator.getFile(path));
    }

    private static ImageIcon none() {
        return new ImageIcon();
    }
}

