/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.i18n;

import com.schneide.base.gui.i18n.DisplayInformation;
import com.schneide.base.i18n.EmptyText;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.text.Text;

public class I18NDisplayInformation
implements DisplayInformation {
    private final I18NResolvable title;
    private final I18NResolvable tooltip;

    public I18NDisplayInformation(String titleKey) {
        this(new I18NKey(titleKey), new EmptyText());
    }

    public I18NDisplayInformation(String titleKey, String tooltipKey) {
        this(new I18NKey(titleKey), new I18NKey(tooltipKey));
    }

    public I18NDisplayInformation(I18NResolvable title) {
        this(title, new EmptyText());
    }

    public I18NDisplayInformation(I18NResolvable title, I18NResolvable tooltip) {
        this.title = title;
        this.tooltip = tooltip;
    }

    @Override
    public boolean hasTitle() {
        return this.title.isResolvableWithoutFallback();
    }

    @Override
    public String getTitle() {
        return this.title.resolvedText();
    }

    @Override
    public String getTooltip() {
        if (this.tooltip.isResolvableWithoutFallback()) {
            return this.tooltip.resolvedText();
        }
        return "";
    }

    @Override
    public boolean hasTooltip() {
        return !Text.isEmpty(this.getTooltip());
    }
}

