/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.i18n;

import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.I18NText;
import com.schneide.base.i18n.model.I18NKeyed;
import com.schneide.base.logging.LoggedObject;

public abstract class I18NContext
extends LoggedObject {
    private final I18NKey i18nKeyBase;

    public I18NContext() {
        this("");
    }

    public I18NContext(String directKeyBase) {
        this(new I18NKey(directKeyBase));
    }

    public I18NContext(I18NKeyed keyBase) {
        this.i18nKeyBase = keyBase.getI18NKey();
    }

    protected final I18NKey getI18NBase() {
        return this.i18nKeyBase;
    }

    protected final I18NKey getFullKey(String keyPart) {
        return this.getI18NBase().withKeyPart(keyPart);
    }

    protected final String getTextEntry(String keyPart) {
        return this.getI18NBase().withKeyPart(keyPart).resolvedText();
    }

    protected final String getTextEntry(String keyPart, Object ... parameters) {
        return new I18NText(this.getFullKey(keyPart), parameters).resolvedText();
    }
}

