/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog.generic;

import com.schneide.base.gui.dialog.generic.SessionlessProgressDialog;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.NotI18NYet;

public final class BusyDialog {
    private final SessionlessProgressDialog dialog;
    private boolean isClosed;

    private BusyDialog(WindowStack stack) {
        this.dialog = new SessionlessProgressDialog(stack, false);
        this.dialog.setMessage(new NotI18NYet("Das System arbeitet...", new Object[0]));
        this.isClosed = false;
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.dialog.closeDialog(this.dialog.getCancelButton());
    }

    protected void show() {
        this.dialog.changeTitle(new NotI18NYet("Bitte warten", new Object[0]).text());
        this.dialog.showDialog();
    }

    public static BusyDialog createAndShow(WindowStack stack) {
        BusyDialog result = new BusyDialog(stack);
        result.show();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <RESULT> RESULT perform(WindowStack stack, WorkUnit<RESULT> work) {
        try (BusyDialog dialog = BusyDialog.createAndShow(stack);){
            RESULT RESULT = work.performWith(dialog);
            return RESULT;
        }
    }

    public static interface WorkUnit<RESULT> {
        public RESULT performWith(BusyDialog var1);
    }
}

