/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog.defaults.timed;

import com.ezware.common.Markup;
import com.schneide.base.gui.dialog.defaults.fancy.FancyDialog;
import com.schneide.base.gui.dialog.defaults.fancy.FancyDialogInformation;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.i18n.DirectText;
import com.schneide.base.threading.DelayedExecutable;
import com.schneide.base.threading.DelayedLoopingExecutable;
import com.schneide.base.threading.delay.LeadingDelay;
import javax.measure.Measurable;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jscience.physics.amount.Amount;

public class TimedFancyDialog
extends FancyDialog {
    private final Measurable<Duration> waitOnUser;
    private JLabel waitLabel;

    public TimedFancyDialog(FancyDialogInformation textProvider, Measurable<Duration> waitOnUser) {
        super(textProvider);
        this.waitOnUser = waitOnUser;
    }

    @Override
    protected void buildUI() {
        super.buildUI();
        EDT.only();
        this.waitLabel = new JLabel(TimedFancyDialog.getTimerMessage(this.waitOnUser));
        this.getTaskDialog().setFixedComponent((JComponent)this.waitLabel);
    }

    @Override
    protected void afterInitBeforeShow() {
        super.afterInitBeforeShow();
        EDT.only();
        final TimerMessageUpdater messageUpdater = new TimerMessageUpdater(this.waitLabel, this.waitOnUser);
        DelayedExecutable closer = new DelayedExecutable("TimedDialog closer", new LeadingDelay(this.waitOnUser)){

            @Override
            protected void executeFunctionality() {
                messageUpdater.stopExecution();
                EDT.perform(() -> TimedFancyDialog.this.getTaskDialog().setVisible(false));
            }
        };
        messageUpdater.startExecution();
        closer.startExecution();
    }

    protected static String getTimerMessage(Measurable<Duration> remainingWait) {
        return Markup.toHTML((String)new DirectText("<i>Dieser Dialog schlie\u00dft sich automatisch in {0}</i>", remainingWait).resolvedText());
    }

    protected static class TimerMessageUpdater
    extends DelayedLoopingExecutable {
        private final JLabel messageLabel;
        private Measurable<Duration> currentWait;

        public TimerMessageUpdater(JLabel messageLabel, Measurable<Duration> initialWait) {
            super("TimedDialog message timer updater", new LeadingDelay(1000L));
            this.messageLabel = messageLabel;
            this.currentWait = initialWait;
        }

        @Override
        protected void executeWithinLoop() throws Exception {
            EDT.never();
            this.currentWait = Amount.valueOf((long)(this.currentWait.longValue((Unit)SI.SECOND) - 1L), (Unit)SI.SECOND);
            EDT.perform(() -> this.messageLabel.setText(TimedFancyDialog.getTimerMessage(this.currentWait)));
        }
    }
}

