/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog.defaults.fancy;

import com.schneide.base.gui.dialog.defaults.fancy.DialogType;
import com.schneide.base.gui.dialog.defaults.fancy.FancyDialog;
import com.schneide.base.gui.dialog.defaults.fancy.FancyDialogInformation;
import com.schneide.base.gui.dialog.defaults.fancy.GenericDialogInformation;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.i18n.DirectText;
import com.schneide.base.i18n.model.I18Nable;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import java.util.ArrayList;

public final class FancyErrorDialog {
    private static final int maximumStacktraceLength = 7;
    private final FancyDialog dialog;

    private FancyErrorDialog(FancyDialogInformation info) {
        this.dialog = new FancyDialog(info);
    }

    public static FancyErrorDialog with(I18Nable title, I18Nable message, Exception cause) {
        GenericDialogInformation info = new GenericDialogInformation().forType(DialogType.ERROR);
        info.withTitle(title);
        info.withMessage("<html><b>" + message.resolvedText() + "</b></html>");
        info.withHeadline(new DirectText("Ein Fehler ist aufgetreten:"));
        info.setDetails(FancyErrorDialog.asStacktrace(cause));
        return new FancyErrorDialog(info);
    }

    public static String asStacktrace(Exception cause) {
        DirectChunkBuffer result = new DirectChunkBuffer("\n");
        result.add(cause.getClass().getSimpleName() + ": " + cause.getLocalizedMessage());
        result.add("occurred at");
        for (StackTraceElement each : FancyErrorDialog.traceOf(cause)) {
            result.add(each.toString());
        }
        return ((Object)result).toString();
    }

    private static Iterable<StackTraceElement> traceOf(Exception cause) {
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>();
        int lineCount = 0;
        for (StackTraceElement each : cause.getStackTrace()) {
            result.add(each);
            if (++lineCount > 7) break;
        }
        return result;
    }

    public void show() {
        EDT.perform(this.dialog::show);
    }
}

