/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog.defaults.fancy;

import com.ezware.common.Markup;
import com.ezware.dialog.task.TaskDialog;
import com.schneide.base.gui.support.WidgetNamer;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.i18n.NotI18NYet;
import com.schneide.base.i18n.model.I18NResolvable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;

public final class CommonDialogs {
    private CommonDialogs() {
    }

    public static QuestionDialogBuilder question() {
        return new QuestionDialogBuilder();
    }

    public static class QuestionDialogBuilder {
        private final TaskDialog dialog = new TaskDialog("");

        protected QuestionDialogBuilder() {
            this.dialog.setIcon((Icon)TaskDialog.StandardIcon.QUESTION);
            this.dialog.setCommands(new TaskDialog.Command[]{TaskDialog.StandardCommand.OK.derive(new NotI18NYet("Ja", new Object[0]).text()), TaskDialog.StandardCommand.CANCEL.derive(new NotI18NYet("Nein", new Object[0]).text())});
        }

        public QuestionDialogBuilder withTitle(I18NResolvable title) {
            return this.withTitle(title.resolvedText());
        }

        public QuestionDialogBuilder withTitle(String title) {
            this.dialog.setTitle(title);
            this.dialog.getDialog().setName(title);
            return this;
        }

        public QuestionDialogBuilder withIntroduction(I18NResolvable instruction) {
            return this.withIntroduction(instruction.resolvedText());
        }

        public QuestionDialogBuilder withIntroduction(String instruction) {
            this.dialog.setInstruction(instruction);
            return this;
        }

        public QuestionDialogBuilder withQuestion(I18NResolvable text) {
            return this.withQuestion(text.resolvedText());
        }

        public QuestionDialogBuilder withQuestion(String text) {
            this.dialog.setText(text);
            return this;
        }

        public TaskDialog build() {
            EDT.performBlocking(() -> {
                JDialog internalDialog = this.dialog.getDialog();
                new WidgetNamer().nameAllIn(internalDialog.getContentPane());
            });
            return this.dialog;
        }

        public boolean ask() {
            TaskDialog.Command answer = this.build().show();
            return answer.equals((Object)TaskDialog.StandardCommand.OK);
        }

        public QuestionDialogBuilder withAdditionalDetails(String details) {
            this.dialog.getDetails().setExpandableComponent((JComponent)new JLabel(Markup.toHTML((String)details)));
            this.dialog.getDetails().setExpanded(false);
            return this;
        }

        public QuestionDialogBuilder withAdditionalDetails(I18NResolvable details) {
            return this.withAdditionalDetails(details.resolvedText());
        }
    }
}

