/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog.defaults;

import com.schneide.base.gui.dialog.defaults.DialogOptionWrapping;
import com.schneide.base.gui.dialog.model.DialogOption;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.I18NText;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.i18n.model.I18Nable;
import javax.swing.JOptionPane;

public final class DefaultDialog {
    public static final String I18N_MESSAGE = "message";
    public static final String I18N_TITLE = "title";
    private static final DialogOption JUSTCLOSED_OPTION = new DialogOption(){

        @Override
        public String getDisplayName() {
            return "Dialog schlie\u00dfen";
        }

        @Override
        public boolean isDefaultOption() {
            return false;
        }
    };

    private DefaultDialog() {
    }

    public static void showErrorDialog(WindowStack windowStack, I18NKey i18nKey, Object ... parameters) {
        DefaultDialog.showErrorDialog(windowStack, new I18NText(i18nKey.withKeyPart(I18N_TITLE), parameters), new I18NText(i18nKey.withKeyPart(I18N_MESSAGE), parameters));
    }

    public static void showErrorDialogFor(WindowStack windowStack, I18NResolvable baseI18N) {
        DefaultDialog.showErrorDialog(windowStack, DefaultDialog.getDefaultTitleSpecification(baseI18N), DefaultDialog.getDefaultMessageSpecification(baseI18N));
    }

    private static I18NText getDefaultTitleSpecification(I18NResolvable base) {
        return DefaultDialog.getDefaultSpecification(base, I18N_TITLE);
    }

    private static I18NText getDefaultMessageSpecification(I18NResolvable base) {
        return DefaultDialog.getDefaultSpecification(base, I18N_MESSAGE);
    }

    private static I18NText getDefaultSpecification(I18NResolvable base, String appendix) {
        return new I18NText(base.getI18NKey().withKeyPart(appendix), base.getParameters());
    }

    public static void showErrorDialog(WindowStack windowStack, I18NResolvable title, I18NResolvable message) {
        DefaultDialog.showErrorDialog(windowStack, title.resolvedText(), message.resolvedText());
    }

    public static void showErrorDialog(WindowStack windowStack, String title, String message) {
        DefaultDialog.showNotificationDialog(windowStack, title, message, 0);
    }

    public static DialogOption showErrorOptionDialog(WindowStack windowStack, I18NKey titleKey, I18NKey messageKey, DialogOption[] options, Object ... parameters) {
        return DefaultDialog.showErrorOptionDialog(windowStack, new I18NText(titleKey, parameters), new I18NText(messageKey, parameters), options);
    }

    public static DialogOption showErrorOptionDialog(WindowStack windowStack, I18NKey i18nKey, DialogOption[] options, Object ... parameters) {
        return DefaultDialog.showErrorOptionDialog(windowStack, I18NKey.buildFromContext(i18nKey, I18N_TITLE), I18NKey.buildFromContext(i18nKey, I18N_MESSAGE), options, parameters);
    }

    public static DialogOption showErrorOptionDialog(WindowStack windowStack, I18NResolvable titleSpecification, I18NResolvable messageSpecification, DialogOption ... options) {
        return DefaultDialog.showErrorOptionDialog(windowStack, titleSpecification.resolvedText(), messageSpecification.resolvedText(), options);
    }

    public static DialogOption showErrorOptionDialog(WindowStack windowStack, String title, String message, DialogOption ... options) {
        return DefaultDialog.showOptionDialog(windowStack, title, message, options, 0);
    }

    public static void showInformationDialog(WindowStack windowStack, I18NKey i18nKey, Object ... parameters) {
        DefaultDialog.showInformationDialog(windowStack, new I18NText(i18nKey.withKeyPart(I18N_TITLE), parameters), new I18NText(i18nKey.withKeyPart(I18N_MESSAGE), parameters));
    }

    public static void showInformationDialog(WindowStack windowStack, I18Nable title, I18Nable message) {
        DefaultDialog.showInformationDialog(windowStack, title.resolvedText(), message.resolvedText());
    }

    public static void showInformationDialog(WindowStack windowStack, String title, String message) {
        DefaultDialog.showMessageDialog(windowStack, title, message);
    }

    public static DialogOption showInformationOptionDialog(WindowStack windowStack, I18NKey titleKey, I18NKey messageKey, DialogOption[] options, Object ... parameters) {
        return DefaultDialog.showInformationOptionDialog(windowStack, new I18NText(titleKey, parameters).resolvedText(), new I18NText(messageKey, parameters).resolvedText(), options);
    }

    public static DialogOption showInformationOptionDialog(WindowStack windowStack, I18NKey i18nKey, DialogOption[] options, Object ... parameters) {
        return DefaultDialog.showInformationOptionDialog(windowStack, I18NKey.buildFromContext(i18nKey, I18N_TITLE), I18NKey.buildFromContext(i18nKey, I18N_MESSAGE), options, parameters);
    }

    public static DialogOption showInformationOptionDialog(WindowStack windowStack, String title, String message, DialogOption[] options) {
        return DefaultDialog.showOptionDialog(windowStack, title, message, options, 1);
    }

    public static void showMessageDialog(WindowStack windowStack, I18NKey i18nKey) {
        DefaultDialog.showMessageDialog(windowStack, i18nKey.withKeyPart(I18N_TITLE), i18nKey.withKeyPart(I18N_MESSAGE));
    }

    public static void showMessageDialog(WindowStack windowStack, I18NResolvable title, I18NResolvable message) {
        DefaultDialog.showMessageDialog(windowStack, title.resolvedText(), message.resolvedText());
    }

    public static void showMessageDialog(WindowStack windowStack, String title, String message) {
        DefaultDialog.showNotificationDialog(windowStack, title, message, 1);
    }

    public static void showNotificationDialog(WindowStack windowStack, I18NKey titleKey, I18NKey messageKey, int messageType) {
        DefaultDialog.showNotificationDialog(windowStack, titleKey.resolvedText(), messageKey.resolvedText(), messageType);
    }

    public static void showNotificationDialog(WindowStack windowStack, I18NKey i18nKey, int messageType) {
        DefaultDialog.showNotificationDialog(windowStack, i18nKey.withKeyPart(I18N_TITLE), i18nKey.withKeyPart(I18N_MESSAGE), messageType);
    }

    public static void showNotificationDialog(WindowStack windowStack, String title, String message, int messageType) {
        JOptionPane.showMessageDialog(windowStack.getActiveWindow(), message, title, messageType);
    }

    public static DialogOption showOptionDialog(WindowStack windowStack, String title, String message, DialogOption[] options, int messageType) {
        DialogOptionWrapping wrapping = new DialogOptionWrapping(options);
        int answerIndex = JOptionPane.showOptionDialog(windowStack.getActiveWindow(), message, title, 1, messageType, null, wrapping.getOptions(), wrapping.getDefaultOption());
        if (answerIndex < 0 || answerIndex >= wrapping.getOptionCount()) {
            return JUSTCLOSED_OPTION;
        }
        return wrapping.getOptionAt(answerIndex).getOption();
    }

    public static void showWarningDialog(WindowStack windowStack, I18NKey titleKey, I18NKey messageKey, Object ... parameters) {
        DefaultDialog.showWarningDialog(windowStack, new I18NText(titleKey, parameters), new I18NText(messageKey, parameters));
    }

    public static void showWarningDialog(WindowStack windowStack, I18NKey i18nKey, Object ... parameters) {
        DefaultDialog.showWarningDialog(windowStack, new I18NText(i18nKey.withKeyPart(I18N_TITLE), parameters), new I18NText(i18nKey.withKeyPart(I18N_MESSAGE), parameters));
    }

    public static void showWarningDialog(WindowStack windowStack, I18NResolvable title, I18NResolvable message) {
        DefaultDialog.showNotificationDialog(windowStack, title.resolvedText(), message.resolvedText(), 2);
    }

    public static DialogOption showWarningOptionDialog(WindowStack windowStack, I18NKey titleKey, I18NKey messageKey, DialogOption[] options, Object ... parameters) {
        return DefaultDialog.showWarningOptionDialog(windowStack, new I18NText(titleKey, parameters).resolvedText(), new I18NText(messageKey, parameters).resolvedText(), options);
    }

    public static DialogOption showWarningOptionDialog(WindowStack windowStack, I18NKey i18nKey, DialogOption[] options, Object ... parameters) {
        return DefaultDialog.showWarningOptionDialog(windowStack, I18NKey.buildFromContext(i18nKey, I18N_TITLE), I18NKey.buildFromContext(i18nKey, I18N_MESSAGE), options, parameters);
    }

    public static DialogOption showWarningOptionDialog(WindowStack windowStack, String title, String message, DialogOption[] options) {
        return DefaultDialog.showOptionDialog(windowStack, title, message, options, 2);
    }

    public static class DialogOptionWrapper {
        private final DialogOption option;

        public DialogOptionWrapper(DialogOption option) {
            this.option = option;
        }

        public String toString() {
            return this.option.getDisplayName();
        }

        public DialogOption getOption() {
            return this.option;
        }
    }
}

